package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait AssistantStatus {
  def unwrap: software.amazon.awssdk.services.wisdom.model.AssistantStatus
}
object AssistantStatus {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.AssistantStatus
  ): zio.aws.wisdom.model.AssistantStatus = value match {
    case software.amazon.awssdk.services.wisdom.model.AssistantStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.AssistantStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.wisdom.model.AssistantStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.wisdom.model.AssistantStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.wisdom.model.AssistantStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.wisdom.model.AssistantStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.wisdom.model.AssistantStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.AssistantStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.AssistantStatus =
      software.amazon.awssdk.services.wisdom.model.AssistantStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS extends zio.aws.wisdom.model.AssistantStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.AssistantStatus =
      software.amazon.awssdk.services.wisdom.model.AssistantStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_FAILED extends zio.aws.wisdom.model.AssistantStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.AssistantStatus =
      software.amazon.awssdk.services.wisdom.model.AssistantStatus.CREATE_FAILED
  }
  case object ACTIVE extends zio.aws.wisdom.model.AssistantStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.AssistantStatus =
      software.amazon.awssdk.services.wisdom.model.AssistantStatus.ACTIVE
  }
  case object DELETE_IN_PROGRESS extends zio.aws.wisdom.model.AssistantStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.AssistantStatus =
      software.amazon.awssdk.services.wisdom.model.AssistantStatus.DELETE_IN_PROGRESS
  }
  case object DELETE_FAILED extends zio.aws.wisdom.model.AssistantStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.AssistantStatus =
      software.amazon.awssdk.services.wisdom.model.AssistantStatus.DELETE_FAILED
  }
  case object DELETED extends zio.aws.wisdom.model.AssistantStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.AssistantStatus =
      software.amazon.awssdk.services.wisdom.model.AssistantStatus.DELETED
  }
}
