package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.Uuid
import scala.jdk.CollectionConverters.*
final case class AssistantAssociationInputData(
    knowledgeBaseId: Option[Uuid] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.AssistantAssociationInputData = {
    import AssistantAssociationInputData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.AssistantAssociationInputData
      .builder()
      .optionallyWith(
        knowledgeBaseId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.knowledgeBaseId)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.AssistantAssociationInputData.ReadOnly =
    zio.aws.wisdom.model.AssistantAssociationInputData.wrap(buildAwsValue())
}
object AssistantAssociationInputData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.AssistantAssociationInputData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.AssistantAssociationInputData =
      zio.aws.wisdom.model
        .AssistantAssociationInputData(knowledgeBaseId.map(value => value))
    def knowledgeBaseId: Option[Uuid]
    def getKnowledgeBaseId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("knowledgeBaseId", knowledgeBaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.AssistantAssociationInputData
  ) extends zio.aws.wisdom.model.AssistantAssociationInputData.ReadOnly {
    override val knowledgeBaseId: Option[Uuid] = scala
      .Option(impl.knowledgeBaseId())
      .map(value => zio.aws.wisdom.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.AssistantAssociationInputData
  ): zio.aws.wisdom.model.AssistantAssociationInputData.ReadOnly = new Wrapper(
    impl
  )
}
