package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class SearchSessionsResponse(
    nextToken: Option[NextToken] = None,
    sessionSummaries: Iterable[zio.aws.wisdom.model.SessionSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.SearchSessionsResponse = {
    import SearchSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.SearchSessionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .sessionSummaries(sessionSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.SearchSessionsResponse.ReadOnly =
    zio.aws.wisdom.model.SearchSessionsResponse.wrap(buildAwsValue())
}
object SearchSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.SearchSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.SearchSessionsResponse =
      zio.aws.wisdom.model.SearchSessionsResponse(
        nextToken.map(value => value),
        sessionSummaries.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[NextToken]
    def sessionSummaries: List[zio.aws.wisdom.model.SessionSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSessionSummaries: ZIO[Any, Nothing, List[
      zio.aws.wisdom.model.SessionSummary.ReadOnly
    ]] = ZIO.succeed(sessionSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.SearchSessionsResponse
  ) extends zio.aws.wisdom.model.SearchSessionsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NextToken(value))
    override val sessionSummaries
        : List[zio.aws.wisdom.model.SessionSummary.ReadOnly] = impl
      .sessionSummaries()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.SessionSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.SearchSessionsResponse
  ): zio.aws.wisdom.model.SearchSessionsResponse.ReadOnly = new Wrapper(impl)
}
