package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateKnowledgeBaseResponse(
    knowledgeBase: Option[zio.aws.wisdom.model.KnowledgeBaseData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseResponse = {
    import CreateKnowledgeBaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseResponse
      .builder()
      .optionallyWith(knowledgeBase.map(value => value.buildAwsValue()))(
        _.knowledgeBase
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.CreateKnowledgeBaseResponse.ReadOnly =
    zio.aws.wisdom.model.CreateKnowledgeBaseResponse.wrap(buildAwsValue())
}
object CreateKnowledgeBaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateKnowledgeBaseResponse =
      zio.aws.wisdom.model.CreateKnowledgeBaseResponse(
        knowledgeBase.map(value => value.asEditable)
      )
    def knowledgeBase: Option[zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly]
    def getKnowledgeBase
        : ZIO[Any, AwsError, zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly] =
      AwsError.unwrapOptionField("knowledgeBase", knowledgeBase)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseResponse
  ) extends zio.aws.wisdom.model.CreateKnowledgeBaseResponse.ReadOnly {
    override val knowledgeBase
        : Option[zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly] = scala
      .Option(impl.knowledgeBase())
      .map(value => zio.aws.wisdom.model.KnowledgeBaseData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseResponse
  ): zio.aws.wisdom.model.CreateKnowledgeBaseResponse.ReadOnly = new Wrapper(
    impl
  )
}
