package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.{Uuid, RelevanceScore}
import scala.jdk.CollectionConverters.*
final case class ResultData(
    document: zio.aws.wisdom.model.Document,
    relevanceScore: Option[RelevanceScore] = None,
    resultId: Uuid
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ResultData = {
    import ResultData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ResultData
      .builder()
      .document(document.buildAwsValue())
      .optionallyWith(
        relevanceScore.map(value =>
          RelevanceScore.unwrap(value): java.lang.Double
        )
      )(_.relevanceScore)
      .resultId(Uuid.unwrap(resultId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ResultData.ReadOnly =
    zio.aws.wisdom.model.ResultData.wrap(buildAwsValue())
}
object ResultData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wisdom.model.ResultData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ResultData =
      zio.aws.wisdom.model.ResultData(
        document.asEditable,
        relevanceScore.map(value => value),
        resultId
      )
    def document: zio.aws.wisdom.model.Document.ReadOnly
    def relevanceScore: Option[RelevanceScore]
    def resultId: Uuid
    def getDocument: ZIO[Any, Nothing, zio.aws.wisdom.model.Document.ReadOnly] =
      ZIO.succeed(document)
    def getRelevanceScore: ZIO[Any, AwsError, RelevanceScore] =
      AwsError.unwrapOptionField("relevanceScore", relevanceScore)
    def getResultId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(resultId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ResultData
  ) extends zio.aws.wisdom.model.ResultData.ReadOnly {
    override val document: zio.aws.wisdom.model.Document.ReadOnly =
      zio.aws.wisdom.model.Document.wrap(impl.document())
    override val relevanceScore: Option[RelevanceScore] = scala
      .Option(impl.relevanceScore())
      .map(value => zio.aws.wisdom.model.primitives.RelevanceScore(value))
    override val resultId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.resultId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ResultData
  ): zio.aws.wisdom.model.ResultData.ReadOnly = new Wrapper(impl)
}
