package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class QueryAssistantResponse(
    nextToken: Option[NextToken] = None,
    results: Iterable[zio.aws.wisdom.model.ResultData]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QueryAssistantResponse = {
    import QueryAssistantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QueryAssistantResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .results(results.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QueryAssistantResponse.ReadOnly =
    zio.aws.wisdom.model.QueryAssistantResponse.wrap(buildAwsValue())
}
object QueryAssistantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QueryAssistantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QueryAssistantResponse =
      zio.aws.wisdom.model.QueryAssistantResponse(
        nextToken.map(value => value),
        results.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[NextToken]
    def results: List[zio.aws.wisdom.model.ResultData.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResults
        : ZIO[Any, Nothing, List[zio.aws.wisdom.model.ResultData.ReadOnly]] =
      ZIO.succeed(results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QueryAssistantResponse
  ) extends zio.aws.wisdom.model.QueryAssistantResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NextToken(value))
    override val results: List[zio.aws.wisdom.model.ResultData.ReadOnly] = impl
      .results()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.ResultData.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QueryAssistantResponse
  ): zio.aws.wisdom.model.QueryAssistantResponse.ReadOnly = new Wrapper(impl)
}
