package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAssistantAssociationResponse(
    assistantAssociation: Option[
      zio.aws.wisdom.model.AssistantAssociationData
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationResponse = {
    import GetAssistantAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationResponse
      .builder()
      .optionallyWith(assistantAssociation.map(value => value.buildAwsValue()))(
        _.assistantAssociation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.GetAssistantAssociationResponse.ReadOnly =
    zio.aws.wisdom.model.GetAssistantAssociationResponse.wrap(buildAwsValue())
}
object GetAssistantAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetAssistantAssociationResponse =
      zio.aws.wisdom.model.GetAssistantAssociationResponse(
        assistantAssociation.map(value => value.asEditable)
      )
    def assistantAssociation
        : Option[zio.aws.wisdom.model.AssistantAssociationData.ReadOnly]
    def getAssistantAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.AssistantAssociationData.ReadOnly
    ] = AwsError.unwrapOptionField("assistantAssociation", assistantAssociation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationResponse
  ) extends zio.aws.wisdom.model.GetAssistantAssociationResponse.ReadOnly {
    override val assistantAssociation
        : Option[zio.aws.wisdom.model.AssistantAssociationData.ReadOnly] = scala
      .Option(impl.assistantAssociation())
      .map(value => zio.aws.wisdom.model.AssistantAssociationData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationResponse
  ): zio.aws.wisdom.model.GetAssistantAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
