package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.SyntheticDocumentTextString
import scala.jdk.CollectionConverters.*
final case class DocumentText(
    highlights: Option[Iterable[zio.aws.wisdom.model.Highlight]] = None,
    text: Option[SyntheticDocumentTextString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.DocumentText = {
    import DocumentText.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.DocumentText
      .builder()
      .optionallyWith(
        highlights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.highlights)
      .optionallyWith(
        text.map(value =>
          SyntheticDocumentTextString.unwrap(value): java.lang.String
        )
      )(_.text)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.DocumentText.ReadOnly =
    zio.aws.wisdom.model.DocumentText.wrap(buildAwsValue())
}
object DocumentText {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.DocumentText
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.DocumentText =
      zio.aws.wisdom.model.DocumentText(
        highlights.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        text.map(value => value)
      )
    def highlights: Option[List[zio.aws.wisdom.model.Highlight.ReadOnly]]
    def text: Option[SyntheticDocumentTextString]
    def getHighlights
        : ZIO[Any, AwsError, List[zio.aws.wisdom.model.Highlight.ReadOnly]] =
      AwsError.unwrapOptionField("highlights", highlights)
    def getText: ZIO[Any, AwsError, SyntheticDocumentTextString] =
      AwsError.unwrapOptionField("text", text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.DocumentText
  ) extends zio.aws.wisdom.model.DocumentText.ReadOnly {
    override val highlights
        : Option[List[zio.aws.wisdom.model.Highlight.ReadOnly]] = scala
      .Option(impl.highlights())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wisdom.model.Highlight.wrap(item)
        }.toList
      )
    override val text: Option[SyntheticDocumentTextString] = scala
      .Option(impl.text())
      .map(value =>
        zio.aws.wisdom.model.primitives.SyntheticDocumentTextString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.DocumentText
  ): zio.aws.wisdom.model.DocumentText.ReadOnly = new Wrapper(impl)
}
