package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.{Uuid, Arn}
import scala.jdk.CollectionConverters.*
final case class ContentReference(
    contentArn: Option[Arn] = None,
    contentId: Option[Uuid] = None,
    knowledgeBaseArn: Option[Arn] = None,
    knowledgeBaseId: Option[Uuid] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ContentReference = {
    import ContentReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ContentReference
      .builder()
      .optionallyWith(
        contentArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.contentArn)
      .optionallyWith(
        contentId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.contentId)
      .optionallyWith(
        knowledgeBaseArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.knowledgeBaseArn)
      .optionallyWith(
        knowledgeBaseId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.knowledgeBaseId)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ContentReference.ReadOnly =
    zio.aws.wisdom.model.ContentReference.wrap(buildAwsValue())
}
object ContentReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ContentReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ContentReference =
      zio.aws.wisdom.model.ContentReference(
        contentArn.map(value => value),
        contentId.map(value => value),
        knowledgeBaseArn.map(value => value),
        knowledgeBaseId.map(value => value)
      )
    def contentArn: Option[Arn]
    def contentId: Option[Uuid]
    def knowledgeBaseArn: Option[Arn]
    def knowledgeBaseId: Option[Uuid]
    def getContentArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("contentArn", contentArn)
    def getContentId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("contentId", contentId)
    def getKnowledgeBaseArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("knowledgeBaseArn", knowledgeBaseArn)
    def getKnowledgeBaseId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("knowledgeBaseId", knowledgeBaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ContentReference
  ) extends zio.aws.wisdom.model.ContentReference.ReadOnly {
    override val contentArn: Option[Arn] = scala
      .Option(impl.contentArn())
      .map(value => zio.aws.wisdom.model.primitives.Arn(value))
    override val contentId: Option[Uuid] = scala
      .Option(impl.contentId())
      .map(value => zio.aws.wisdom.model.primitives.Uuid(value))
    override val knowledgeBaseArn: Option[Arn] = scala
      .Option(impl.knowledgeBaseArn())
      .map(value => zio.aws.wisdom.model.primitives.Arn(value))
    override val knowledgeBaseId: Option[Uuid] = scala
      .Option(impl.knowledgeBaseId())
      .map(value => zio.aws.wisdom.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ContentReference
  ): zio.aws.wisdom.model.ContentReference.ReadOnly = new Wrapper(impl)
}
