package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.{NonEmptyString, GenericArn}
import scala.jdk.CollectionConverters.*
final case class AppIntegrationsConfiguration(
    appIntegrationArn: GenericArn,
    objectFields: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.AppIntegrationsConfiguration = {
    import AppIntegrationsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.AppIntegrationsConfiguration
      .builder()
      .appIntegrationArn(GenericArn.unwrap(appIntegrationArn): java.lang.String)
      .objectFields(objectFields.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.AppIntegrationsConfiguration.ReadOnly =
    zio.aws.wisdom.model.AppIntegrationsConfiguration.wrap(buildAwsValue())
}
object AppIntegrationsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.AppIntegrationsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.AppIntegrationsConfiguration =
      zio.aws.wisdom.model
        .AppIntegrationsConfiguration(appIntegrationArn, objectFields)
    def appIntegrationArn: GenericArn
    def objectFields: List[NonEmptyString]
    def getAppIntegrationArn: ZIO[Any, Nothing, GenericArn] =
      ZIO.succeed(appIntegrationArn)
    def getObjectFields: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(objectFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.AppIntegrationsConfiguration
  ) extends zio.aws.wisdom.model.AppIntegrationsConfiguration.ReadOnly {
    override val appIntegrationArn: GenericArn =
      zio.aws.wisdom.model.primitives.GenericArn(impl.appIntegrationArn())
    override val objectFields: List[NonEmptyString] = impl
      .objectFields()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.AppIntegrationsConfiguration
  ): zio.aws.wisdom.model.AppIntegrationsConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
