package zio.aws.wisdom
import zio.aws.wisdom.model.SearchContentResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.wisdom.model.{
  DeleteAssistantAssociationRequest,
  GetContentSummaryRequest,
  SearchContentRequest,
  DeleteKnowledgeBaseRequest,
  GetContentRequest,
  UpdateKnowledgeBaseTemplateUriRequest,
  ListAssistantsRequest,
  UpdateContentRequest,
  ListTagsForResourceRequest,
  GetKnowledgeBaseRequest,
  CreateKnowledgeBaseRequest,
  GetRecommendationsRequest,
  QueryAssistantRequest,
  CreateSessionRequest,
  ListKnowledgeBasesRequest,
  GetAssistantAssociationRequest,
  NotifyRecommendationsReceivedRequest,
  GetAssistantRequest,
  SearchSessionsRequest,
  ListAssistantAssociationsRequest,
  GetSessionRequest,
  DeleteContentRequest,
  UntagResourceRequest,
  CreateAssistantRequest,
  RemoveKnowledgeBaseTemplateUriRequest,
  StartContentUploadRequest,
  CreateContentRequest,
  ListContentsRequest,
  TagResourceRequest,
  CreateAssistantAssociationRequest,
  DeleteAssistantRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.wisdom.WisdomAsyncClient
object WisdomMock extends Mock[Wisdom] {
  object GetAssistant
      extends Effect[
        GetAssistantRequest,
        AwsError,
        zio.aws.wisdom.model.GetAssistantResponse.ReadOnly
      ]
  object QueryAssistant
      extends Stream[
        QueryAssistantRequest,
        AwsError,
        zio.aws.wisdom.model.ResultData.ReadOnly
      ]
  object QueryAssistantPaginated
      extends Effect[
        QueryAssistantRequest,
        AwsError,
        zio.aws.wisdom.model.QueryAssistantResponse.ReadOnly
      ]
  object StartContentUpload
      extends Effect[
        StartContentUploadRequest,
        AwsError,
        zio.aws.wisdom.model.StartContentUploadResponse.ReadOnly
      ]
  object DeleteKnowledgeBase
      extends Effect[
        DeleteKnowledgeBaseRequest,
        AwsError,
        zio.aws.wisdom.model.DeleteKnowledgeBaseResponse.ReadOnly
      ]
  object SearchSessions
      extends Stream[
        SearchSessionsRequest,
        AwsError,
        zio.aws.wisdom.model.SessionSummary.ReadOnly
      ]
  object SearchSessionsPaginated
      extends Effect[
        SearchSessionsRequest,
        AwsError,
        zio.aws.wisdom.model.SearchSessionsResponse.ReadOnly
      ]
  object GetAssistantAssociation
      extends Effect[
        GetAssistantAssociationRequest,
        AwsError,
        zio.aws.wisdom.model.GetAssistantAssociationResponse.ReadOnly
      ]
  object GetContent
      extends Effect[
        GetContentRequest,
        AwsError,
        zio.aws.wisdom.model.GetContentResponse.ReadOnly
      ]
  object SearchContent
      extends Stream[
        SearchContentRequest,
        AwsError,
        zio.aws.wisdom.model.ContentSummary.ReadOnly
      ]
  object SearchContentPaginated
      extends Effect[SearchContentRequest, AwsError, ReadOnly]
  object GetRecommendations
      extends Effect[
        GetRecommendationsRequest,
        AwsError,
        zio.aws.wisdom.model.GetRecommendationsResponse.ReadOnly
      ]
  object DeleteAssistantAssociation
      extends Effect[
        DeleteAssistantAssociationRequest,
        AwsError,
        zio.aws.wisdom.model.DeleteAssistantAssociationResponse.ReadOnly
      ]
  object UpdateContent
      extends Effect[
        UpdateContentRequest,
        AwsError,
        zio.aws.wisdom.model.UpdateContentResponse.ReadOnly
      ]
  object UpdateKnowledgeBaseTemplateUri
      extends Effect[
        UpdateKnowledgeBaseTemplateUriRequest,
        AwsError,
        zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse.ReadOnly
      ]
  object GetContentSummary
      extends Effect[
        GetContentSummaryRequest,
        AwsError,
        zio.aws.wisdom.model.GetContentSummaryResponse.ReadOnly
      ]
  object GetKnowledgeBase
      extends Effect[
        GetKnowledgeBaseRequest,
        AwsError,
        zio.aws.wisdom.model.GetKnowledgeBaseResponse.ReadOnly
      ]
  object NotifyRecommendationsReceived
      extends Effect[
        NotifyRecommendationsReceivedRequest,
        AwsError,
        zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse.ReadOnly
      ]
  object ListAssistantAssociations
      extends Stream[
        ListAssistantAssociationsRequest,
        AwsError,
        zio.aws.wisdom.model.AssistantAssociationSummary.ReadOnly
      ]
  object ListAssistantAssociationsPaginated
      extends Effect[
        ListAssistantAssociationsRequest,
        AwsError,
        zio.aws.wisdom.model.ListAssistantAssociationsResponse.ReadOnly
      ]
  object CreateContent
      extends Effect[
        CreateContentRequest,
        AwsError,
        zio.aws.wisdom.model.CreateContentResponse.ReadOnly
      ]
  object CreateKnowledgeBase
      extends Effect[
        CreateKnowledgeBaseRequest,
        AwsError,
        zio.aws.wisdom.model.CreateKnowledgeBaseResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.wisdom.model.UntagResourceResponse.ReadOnly
      ]
  object CreateAssistant
      extends Effect[
        CreateAssistantRequest,
        AwsError,
        zio.aws.wisdom.model.CreateAssistantResponse.ReadOnly
      ]
  object CreateAssistantAssociation
      extends Effect[
        CreateAssistantAssociationRequest,
        AwsError,
        zio.aws.wisdom.model.CreateAssistantAssociationResponse.ReadOnly
      ]
  object DeleteContent
      extends Effect[
        DeleteContentRequest,
        AwsError,
        zio.aws.wisdom.model.DeleteContentResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.wisdom.model.ListTagsForResourceResponse.ReadOnly
      ]
  object RemoveKnowledgeBaseTemplateUri
      extends Effect[
        RemoveKnowledgeBaseTemplateUriRequest,
        AwsError,
        zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.wisdom.model.TagResourceResponse.ReadOnly
      ]
  object CreateSession
      extends Effect[
        CreateSessionRequest,
        AwsError,
        zio.aws.wisdom.model.CreateSessionResponse.ReadOnly
      ]
  object ListContents
      extends Stream[
        ListContentsRequest,
        AwsError,
        zio.aws.wisdom.model.ContentSummary.ReadOnly
      ]
  object ListContentsPaginated
      extends Effect[
        ListContentsRequest,
        AwsError,
        zio.aws.wisdom.model.ListContentsResponse.ReadOnly
      ]
  object GetSession
      extends Effect[
        GetSessionRequest,
        AwsError,
        zio.aws.wisdom.model.GetSessionResponse.ReadOnly
      ]
  object ListAssistants
      extends Stream[
        ListAssistantsRequest,
        AwsError,
        zio.aws.wisdom.model.AssistantSummary.ReadOnly
      ]
  object ListAssistantsPaginated
      extends Effect[
        ListAssistantsRequest,
        AwsError,
        zio.aws.wisdom.model.ListAssistantsResponse.ReadOnly
      ]
  object ListKnowledgeBases
      extends Stream[
        ListKnowledgeBasesRequest,
        AwsError,
        zio.aws.wisdom.model.KnowledgeBaseSummary.ReadOnly
      ]
  object ListKnowledgeBasesPaginated
      extends Effect[
        ListKnowledgeBasesRequest,
        AwsError,
        zio.aws.wisdom.model.ListKnowledgeBasesResponse.ReadOnly
      ]
  object DeleteAssistant
      extends Effect[
        DeleteAssistantRequest,
        AwsError,
        zio.aws.wisdom.model.DeleteAssistantResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Wisdom] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Wisdom {
          val api: WisdomAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Wisdom = this
          def getAssistant(
              request: GetAssistantRequest
          ): IO[AwsError, zio.aws.wisdom.model.GetAssistantResponse.ReadOnly] =
            proxy(GetAssistant, request)
          def queryAssistant(
              request: QueryAssistantRequest
          ): ZStream[Any, AwsError, zio.aws.wisdom.model.ResultData.ReadOnly] =
            rts.unsafeRun(proxy(QueryAssistant, request))
          def queryAssistantPaginated(request: QueryAssistantRequest): IO[
            AwsError,
            zio.aws.wisdom.model.QueryAssistantResponse.ReadOnly
          ] = proxy(QueryAssistantPaginated, request)
          def startContentUpload(request: StartContentUploadRequest): IO[
            AwsError,
            zio.aws.wisdom.model.StartContentUploadResponse.ReadOnly
          ] = proxy(StartContentUpload, request)
          def deleteKnowledgeBase(request: DeleteKnowledgeBaseRequest): IO[
            AwsError,
            zio.aws.wisdom.model.DeleteKnowledgeBaseResponse.ReadOnly
          ] = proxy(DeleteKnowledgeBase, request)
          def searchSessions(request: SearchSessionsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.wisdom.model.SessionSummary.ReadOnly
          ] = rts.unsafeRun(proxy(SearchSessions, request))
          def searchSessionsPaginated(request: SearchSessionsRequest): IO[
            AwsError,
            zio.aws.wisdom.model.SearchSessionsResponse.ReadOnly
          ] = proxy(SearchSessionsPaginated, request)
          def getAssistantAssociation(
              request: GetAssistantAssociationRequest
          ): IO[
            AwsError,
            zio.aws.wisdom.model.GetAssistantAssociationResponse.ReadOnly
          ] = proxy(GetAssistantAssociation, request)
          def getContent(
              request: GetContentRequest
          ): IO[AwsError, zio.aws.wisdom.model.GetContentResponse.ReadOnly] =
            proxy(GetContent, request)
          def searchContent(request: SearchContentRequest): ZStream[
            Any,
            AwsError,
            zio.aws.wisdom.model.ContentSummary.ReadOnly
          ] = rts.unsafeRun(proxy(SearchContent, request))
          def searchContentPaginated(
              request: SearchContentRequest
          ): IO[AwsError, ReadOnly] = proxy(SearchContentPaginated, request)
          def getRecommendations(request: GetRecommendationsRequest): IO[
            AwsError,
            zio.aws.wisdom.model.GetRecommendationsResponse.ReadOnly
          ] = proxy(GetRecommendations, request)
          def deleteAssistantAssociation(
              request: DeleteAssistantAssociationRequest
          ): IO[
            AwsError,
            zio.aws.wisdom.model.DeleteAssistantAssociationResponse.ReadOnly
          ] = proxy(DeleteAssistantAssociation, request)
          def updateContent(
              request: UpdateContentRequest
          ): IO[AwsError, zio.aws.wisdom.model.UpdateContentResponse.ReadOnly] =
            proxy(UpdateContent, request)
          def updateKnowledgeBaseTemplateUri(
              request: UpdateKnowledgeBaseTemplateUriRequest
          ): IO[
            AwsError,
            zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse.ReadOnly
          ] = proxy(UpdateKnowledgeBaseTemplateUri, request)
          def getContentSummary(request: GetContentSummaryRequest): IO[
            AwsError,
            zio.aws.wisdom.model.GetContentSummaryResponse.ReadOnly
          ] = proxy(GetContentSummary, request)
          def getKnowledgeBase(request: GetKnowledgeBaseRequest): IO[
            AwsError,
            zio.aws.wisdom.model.GetKnowledgeBaseResponse.ReadOnly
          ] = proxy(GetKnowledgeBase, request)
          def notifyRecommendationsReceived(
              request: NotifyRecommendationsReceivedRequest
          ): IO[
            AwsError,
            zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse.ReadOnly
          ] = proxy(NotifyRecommendationsReceived, request)
          def listAssistantAssociations(
              request: ListAssistantAssociationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.wisdom.model.AssistantAssociationSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListAssistantAssociations, request))
          def listAssistantAssociationsPaginated(
              request: ListAssistantAssociationsRequest
          ): IO[
            AwsError,
            zio.aws.wisdom.model.ListAssistantAssociationsResponse.ReadOnly
          ] = proxy(ListAssistantAssociationsPaginated, request)
          def createContent(
              request: CreateContentRequest
          ): IO[AwsError, zio.aws.wisdom.model.CreateContentResponse.ReadOnly] =
            proxy(CreateContent, request)
          def createKnowledgeBase(request: CreateKnowledgeBaseRequest): IO[
            AwsError,
            zio.aws.wisdom.model.CreateKnowledgeBaseResponse.ReadOnly
          ] = proxy(CreateKnowledgeBase, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.wisdom.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def createAssistant(request: CreateAssistantRequest): IO[
            AwsError,
            zio.aws.wisdom.model.CreateAssistantResponse.ReadOnly
          ] = proxy(CreateAssistant, request)
          def createAssistantAssociation(
              request: CreateAssistantAssociationRequest
          ): IO[
            AwsError,
            zio.aws.wisdom.model.CreateAssistantAssociationResponse.ReadOnly
          ] = proxy(CreateAssistantAssociation, request)
          def deleteContent(
              request: DeleteContentRequest
          ): IO[AwsError, zio.aws.wisdom.model.DeleteContentResponse.ReadOnly] =
            proxy(DeleteContent, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.wisdom.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def removeKnowledgeBaseTemplateUri(
              request: RemoveKnowledgeBaseTemplateUriRequest
          ): IO[
            AwsError,
            zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriResponse.ReadOnly
          ] = proxy(RemoveKnowledgeBaseTemplateUri, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.wisdom.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def createSession(
              request: CreateSessionRequest
          ): IO[AwsError, zio.aws.wisdom.model.CreateSessionResponse.ReadOnly] =
            proxy(CreateSession, request)
          def listContents(request: ListContentsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.wisdom.model.ContentSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListContents, request))
          def listContentsPaginated(
              request: ListContentsRequest
          ): IO[AwsError, zio.aws.wisdom.model.ListContentsResponse.ReadOnly] =
            proxy(ListContentsPaginated, request)
          def getSession(
              request: GetSessionRequest
          ): IO[AwsError, zio.aws.wisdom.model.GetSessionResponse.ReadOnly] =
            proxy(GetSession, request)
          def listAssistants(request: ListAssistantsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.wisdom.model.AssistantSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListAssistants, request))
          def listAssistantsPaginated(request: ListAssistantsRequest): IO[
            AwsError,
            zio.aws.wisdom.model.ListAssistantsResponse.ReadOnly
          ] = proxy(ListAssistantsPaginated, request)
          def listKnowledgeBases(request: ListKnowledgeBasesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.wisdom.model.KnowledgeBaseSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListKnowledgeBases, request))
          def listKnowledgeBasesPaginated(
              request: ListKnowledgeBasesRequest
          ): IO[
            AwsError,
            zio.aws.wisdom.model.ListKnowledgeBasesResponse.ReadOnly
          ] = proxy(ListKnowledgeBasesPaginated, request)
          def deleteAssistant(request: DeleteAssistantRequest): IO[
            AwsError,
            zio.aws.wisdom.model.DeleteAssistantResponse.ReadOnly
          ] = proxy(DeleteAssistant, request)
        }
      }
    }
    .toLayer
}
