package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{
  ReleaseNotes,
  Timestamp,
  VersionKeyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class MobileSdkRelease(
    releaseVersion: Optional[VersionKeyString] = Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent,
    releaseNotes: Optional[ReleaseNotes] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.wafv2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.MobileSdkRelease = {
    import MobileSdkRelease.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.MobileSdkRelease
      .builder()
      .optionallyWith(
        releaseVersion.map(value =>
          VersionKeyString.unwrap(value): java.lang.String
        )
      )(_.releaseVersion)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        releaseNotes.map(value => ReleaseNotes.unwrap(value): java.lang.String)
      )(_.releaseNotes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.MobileSdkRelease.ReadOnly =
    zio.aws.wafv2.model.MobileSdkRelease.wrap(buildAwsValue())
}
object MobileSdkRelease {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.MobileSdkRelease
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.MobileSdkRelease =
      zio.aws.wafv2.model.MobileSdkRelease(
        releaseVersion.map(value => value),
        timestamp.map(value => value),
        releaseNotes.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def releaseVersion: Optional[VersionKeyString]
    def timestamp: Optional[Timestamp]
    def releaseNotes: Optional[ReleaseNotes]
    def tags: Optional[List[zio.aws.wafv2.model.Tag.ReadOnly]]
    def getReleaseVersion: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("releaseVersion", releaseVersion)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getReleaseNotes: ZIO[Any, AwsError, ReleaseNotes] =
      AwsError.unwrapOptionField("releaseNotes", releaseNotes)
    def getTags: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.MobileSdkRelease
  ) extends zio.aws.wafv2.model.MobileSdkRelease.ReadOnly {
    override val releaseVersion: Optional[VersionKeyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.releaseVersion())
        .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
    override val releaseNotes: Optional[ReleaseNotes] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseNotes())
      .map(value => zio.aws.wafv2.model.primitives.ReleaseNotes(value))
    override val tags: Optional[List[zio.aws.wafv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.MobileSdkRelease
  ): zio.aws.wafv2.model.MobileSdkRelease.ReadOnly = new Wrapper(impl)
}
