package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RequestInspectionACFP(
    payloadType: zio.aws.wafv2.model.PayloadType,
    usernameField: Optional[zio.aws.wafv2.model.UsernameField] =
      Optional.Absent,
    passwordField: Optional[zio.aws.wafv2.model.PasswordField] =
      Optional.Absent,
    emailField: Optional[zio.aws.wafv2.model.EmailField] = Optional.Absent,
    phoneNumberFields: Optional[
      Iterable[zio.aws.wafv2.model.PhoneNumberField]
    ] = Optional.Absent,
    addressFields: Optional[Iterable[zio.aws.wafv2.model.AddressField]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RequestInspectionACFP = {
    import RequestInspectionACFP.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RequestInspectionACFP
      .builder()
      .payloadType(payloadType.unwrap)
      .optionallyWith(usernameField.map(value => value.buildAwsValue()))(
        _.usernameField
      )
      .optionallyWith(passwordField.map(value => value.buildAwsValue()))(
        _.passwordField
      )
      .optionallyWith(emailField.map(value => value.buildAwsValue()))(
        _.emailField
      )
      .optionallyWith(
        phoneNumberFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumberFields)
      .optionallyWith(
        addressFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addressFields)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RequestInspectionACFP.ReadOnly =
    zio.aws.wafv2.model.RequestInspectionACFP.wrap(buildAwsValue())
}
object RequestInspectionACFP {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RequestInspectionACFP
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RequestInspectionACFP =
      zio.aws.wafv2.model.RequestInspectionACFP(
        payloadType,
        usernameField.map(value => value.asEditable),
        passwordField.map(value => value.asEditable),
        emailField.map(value => value.asEditable),
        phoneNumberFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addressFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def payloadType: zio.aws.wafv2.model.PayloadType
    def usernameField: Optional[zio.aws.wafv2.model.UsernameField.ReadOnly]
    def passwordField: Optional[zio.aws.wafv2.model.PasswordField.ReadOnly]
    def emailField: Optional[zio.aws.wafv2.model.EmailField.ReadOnly]
    def phoneNumberFields
        : Optional[List[zio.aws.wafv2.model.PhoneNumberField.ReadOnly]]
    def addressFields: Optional[List[zio.aws.wafv2.model.AddressField.ReadOnly]]
    def getPayloadType: ZIO[Any, Nothing, zio.aws.wafv2.model.PayloadType] =
      ZIO.succeed(payloadType)
    def getUsernameField
        : ZIO[Any, AwsError, zio.aws.wafv2.model.UsernameField.ReadOnly] =
      AwsError.unwrapOptionField("usernameField", usernameField)
    def getPasswordField
        : ZIO[Any, AwsError, zio.aws.wafv2.model.PasswordField.ReadOnly] =
      AwsError.unwrapOptionField("passwordField", passwordField)
    def getEmailField
        : ZIO[Any, AwsError, zio.aws.wafv2.model.EmailField.ReadOnly] =
      AwsError.unwrapOptionField("emailField", emailField)
    def getPhoneNumberFields: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.PhoneNumberField.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumberFields", phoneNumberFields)
    def getAddressFields
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.AddressField.ReadOnly]] =
      AwsError.unwrapOptionField("addressFields", addressFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RequestInspectionACFP
  ) extends zio.aws.wafv2.model.RequestInspectionACFP.ReadOnly {
    override val payloadType: zio.aws.wafv2.model.PayloadType =
      zio.aws.wafv2.model.PayloadType.wrap(impl.payloadType())
    override val usernameField
        : Optional[zio.aws.wafv2.model.UsernameField.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usernameField())
        .map(value => zio.aws.wafv2.model.UsernameField.wrap(value))
    override val passwordField
        : Optional[zio.aws.wafv2.model.PasswordField.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.passwordField())
        .map(value => zio.aws.wafv2.model.PasswordField.wrap(value))
    override val emailField: Optional[zio.aws.wafv2.model.EmailField.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailField())
        .map(value => zio.aws.wafv2.model.EmailField.wrap(value))
    override val phoneNumberFields
        : Optional[List[zio.aws.wafv2.model.PhoneNumberField.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.PhoneNumberField.wrap(item)
          }.toList
        )
    override val addressFields
        : Optional[List[zio.aws.wafv2.model.AddressField.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addressFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.AddressField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RequestInspectionACFP
  ): zio.aws.wafv2.model.RequestInspectionACFP.ReadOnly = new Wrapper(impl)
}
