package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RateLimitUriPath(
    textTransformations: Iterable[zio.aws.wafv2.model.TextTransformation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RateLimitUriPath = {
    import RateLimitUriPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RateLimitUriPath
      .builder()
      .textTransformations(textTransformations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RateLimitUriPath.ReadOnly =
    zio.aws.wafv2.model.RateLimitUriPath.wrap(buildAwsValue())
}
object RateLimitUriPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RateLimitUriPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RateLimitUriPath =
      zio.aws.wafv2.model.RateLimitUriPath(textTransformations.map { item =>
        item.asEditable
      })
    def textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly]
    def getTextTransformations: ZIO[Any, Nothing, List[
      zio.aws.wafv2.model.TextTransformation.ReadOnly
    ]] = ZIO.succeed(textTransformations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RateLimitUriPath
  ) extends zio.aws.wafv2.model.RateLimitUriPath.ReadOnly {
    override val textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly] = impl
      .textTransformations()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.TextTransformation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RateLimitUriPath
  ): zio.aws.wafv2.model.RateLimitUriPath.ReadOnly = new Wrapper(impl)
}
