package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RateLimitQueryString(
    textTransformations: Iterable[zio.aws.wafv2.model.TextTransformation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RateLimitQueryString = {
    import RateLimitQueryString.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RateLimitQueryString
      .builder()
      .textTransformations(textTransformations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RateLimitQueryString.ReadOnly =
    zio.aws.wafv2.model.RateLimitQueryString.wrap(buildAwsValue())
}
object RateLimitQueryString {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RateLimitQueryString
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RateLimitQueryString =
      zio.aws.wafv2.model.RateLimitQueryString(textTransformations.map { item =>
        item.asEditable
      })
    def textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly]
    def getTextTransformations: ZIO[Any, Nothing, List[
      zio.aws.wafv2.model.TextTransformation.ReadOnly
    ]] = ZIO.succeed(textTransformations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RateLimitQueryString
  ) extends zio.aws.wafv2.model.RateLimitQueryString.ReadOnly {
    override val textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly] = impl
      .textTransformations()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.TextTransformation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RateLimitQueryString
  ): zio.aws.wafv2.model.RateLimitQueryString.ReadOnly = new Wrapper(impl)
}
