package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RateBasedStatementCustomKey(
    header: Optional[zio.aws.wafv2.model.RateLimitHeader] = Optional.Absent,
    cookie: Optional[zio.aws.wafv2.model.RateLimitCookie] = Optional.Absent,
    queryArgument: Optional[zio.aws.wafv2.model.RateLimitQueryArgument] =
      Optional.Absent,
    queryString: Optional[zio.aws.wafv2.model.RateLimitQueryString] =
      Optional.Absent,
    httpMethod: Optional[zio.aws.wafv2.model.RateLimitHTTPMethod] =
      Optional.Absent,
    forwardedIP: Optional[zio.aws.wafv2.model.RateLimitForwardedIP] =
      Optional.Absent,
    ip: Optional[zio.aws.wafv2.model.RateLimitIP] = Optional.Absent,
    labelNamespace: Optional[zio.aws.wafv2.model.RateLimitLabelNamespace] =
      Optional.Absent,
    uriPath: Optional[zio.aws.wafv2.model.RateLimitUriPath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RateBasedStatementCustomKey = {
    import RateBasedStatementCustomKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RateBasedStatementCustomKey
      .builder()
      .optionallyWith(header.map(value => value.buildAwsValue()))(_.header)
      .optionallyWith(cookie.map(value => value.buildAwsValue()))(_.cookie)
      .optionallyWith(queryArgument.map(value => value.buildAwsValue()))(
        _.queryArgument
      )
      .optionallyWith(queryString.map(value => value.buildAwsValue()))(
        _.queryString
      )
      .optionallyWith(httpMethod.map(value => value.buildAwsValue()))(
        _.httpMethod
      )
      .optionallyWith(forwardedIP.map(value => value.buildAwsValue()))(
        _.forwardedIP
      )
      .optionallyWith(ip.map(value => value.buildAwsValue()))(_.ip)
      .optionallyWith(labelNamespace.map(value => value.buildAwsValue()))(
        _.labelNamespace
      )
      .optionallyWith(uriPath.map(value => value.buildAwsValue()))(_.uriPath)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RateBasedStatementCustomKey.ReadOnly =
    zio.aws.wafv2.model.RateBasedStatementCustomKey.wrap(buildAwsValue())
}
object RateBasedStatementCustomKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RateBasedStatementCustomKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RateBasedStatementCustomKey =
      zio.aws.wafv2.model.RateBasedStatementCustomKey(
        header.map(value => value.asEditable),
        cookie.map(value => value.asEditable),
        queryArgument.map(value => value.asEditable),
        queryString.map(value => value.asEditable),
        httpMethod.map(value => value.asEditable),
        forwardedIP.map(value => value.asEditable),
        ip.map(value => value.asEditable),
        labelNamespace.map(value => value.asEditable),
        uriPath.map(value => value.asEditable)
      )
    def header: Optional[zio.aws.wafv2.model.RateLimitHeader.ReadOnly]
    def cookie: Optional[zio.aws.wafv2.model.RateLimitCookie.ReadOnly]
    def queryArgument
        : Optional[zio.aws.wafv2.model.RateLimitQueryArgument.ReadOnly]
    def queryString: Optional[zio.aws.wafv2.model.RateLimitQueryString.ReadOnly]
    def httpMethod: Optional[zio.aws.wafv2.model.RateLimitHTTPMethod.ReadOnly]
    def forwardedIP: Optional[zio.aws.wafv2.model.RateLimitForwardedIP.ReadOnly]
    def ip: Optional[zio.aws.wafv2.model.RateLimitIP.ReadOnly]
    def labelNamespace
        : Optional[zio.aws.wafv2.model.RateLimitLabelNamespace.ReadOnly]
    def uriPath: Optional[zio.aws.wafv2.model.RateLimitUriPath.ReadOnly]
    def getHeader
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RateLimitHeader.ReadOnly] =
      AwsError.unwrapOptionField("header", header)
    def getCookie
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RateLimitCookie.ReadOnly] =
      AwsError.unwrapOptionField("cookie", cookie)
    def getQueryArgument: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RateLimitQueryArgument.ReadOnly
    ] = AwsError.unwrapOptionField("queryArgument", queryArgument)
    def getQueryString: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RateLimitQueryString.ReadOnly
    ] = AwsError.unwrapOptionField("queryString", queryString)
    def getHttpMethod
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RateLimitHTTPMethod.ReadOnly] =
      AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getForwardedIP: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RateLimitForwardedIP.ReadOnly
    ] = AwsError.unwrapOptionField("forwardedIP", forwardedIP)
    def getIp: ZIO[Any, AwsError, zio.aws.wafv2.model.RateLimitIP.ReadOnly] =
      AwsError.unwrapOptionField("ip", ip)
    def getLabelNamespace: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RateLimitLabelNamespace.ReadOnly
    ] = AwsError.unwrapOptionField("labelNamespace", labelNamespace)
    def getUriPath
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RateLimitUriPath.ReadOnly] =
      AwsError.unwrapOptionField("uriPath", uriPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RateBasedStatementCustomKey
  ) extends zio.aws.wafv2.model.RateBasedStatementCustomKey.ReadOnly {
    override val header
        : Optional[zio.aws.wafv2.model.RateLimitHeader.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.header())
        .map(value => zio.aws.wafv2.model.RateLimitHeader.wrap(value))
    override val cookie
        : Optional[zio.aws.wafv2.model.RateLimitCookie.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cookie())
        .map(value => zio.aws.wafv2.model.RateLimitCookie.wrap(value))
    override val queryArgument
        : Optional[zio.aws.wafv2.model.RateLimitQueryArgument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryArgument())
        .map(value => zio.aws.wafv2.model.RateLimitQueryArgument.wrap(value))
    override val queryString
        : Optional[zio.aws.wafv2.model.RateLimitQueryString.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryString())
        .map(value => zio.aws.wafv2.model.RateLimitQueryString.wrap(value))
    override val httpMethod
        : Optional[zio.aws.wafv2.model.RateLimitHTTPMethod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpMethod())
        .map(value => zio.aws.wafv2.model.RateLimitHTTPMethod.wrap(value))
    override val forwardedIP
        : Optional[zio.aws.wafv2.model.RateLimitForwardedIP.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forwardedIP())
        .map(value => zio.aws.wafv2.model.RateLimitForwardedIP.wrap(value))
    override val ip: Optional[zio.aws.wafv2.model.RateLimitIP.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ip())
        .map(value => zio.aws.wafv2.model.RateLimitIP.wrap(value))
    override val labelNamespace
        : Optional[zio.aws.wafv2.model.RateLimitLabelNamespace.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelNamespace())
        .map(value => zio.aws.wafv2.model.RateLimitLabelNamespace.wrap(value))
    override val uriPath
        : Optional[zio.aws.wafv2.model.RateLimitUriPath.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uriPath())
        .map(value => zio.aws.wafv2.model.RateLimitUriPath.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RateBasedStatementCustomKey
  ): zio.aws.wafv2.model.RateBasedStatementCustomKey.ReadOnly = new Wrapper(
    impl
  )
}
