package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JA3Fingerprint(
    fallbackBehavior: zio.aws.wafv2.model.FallbackBehavior
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.JA3Fingerprint = {
    import JA3Fingerprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.JA3Fingerprint
      .builder()
      .fallbackBehavior(fallbackBehavior.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.JA3Fingerprint.ReadOnly =
    zio.aws.wafv2.model.JA3Fingerprint.wrap(buildAwsValue())
}
object JA3Fingerprint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.JA3Fingerprint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.JA3Fingerprint =
      zio.aws.wafv2.model.JA3Fingerprint(fallbackBehavior)
    def fallbackBehavior: zio.aws.wafv2.model.FallbackBehavior
    def getFallbackBehavior
        : ZIO[Any, Nothing, zio.aws.wafv2.model.FallbackBehavior] =
      ZIO.succeed(fallbackBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.JA3Fingerprint
  ) extends zio.aws.wafv2.model.JA3Fingerprint.ReadOnly {
    override val fallbackBehavior: zio.aws.wafv2.model.FallbackBehavior =
      zio.aws.wafv2.model.FallbackBehavior.wrap(impl.fallbackBehavior())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.JA3Fingerprint
  ): zio.aws.wafv2.model.JA3Fingerprint.ReadOnly = new Wrapper(impl)
}
