package zio.aws.wafv2.model
import scala.jdk.CollectionConverters._
sealed trait InspectionLevel {
  def unwrap: software.amazon.awssdk.services.wafv2.model.InspectionLevel
}
object InspectionLevel {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.InspectionLevel
  ): zio.aws.wafv2.model.InspectionLevel = value match {
    case software.amazon.awssdk.services.wafv2.model.InspectionLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.InspectionLevel.COMMON =>
      val r = COMMON
      r
    case software.amazon.awssdk.services.wafv2.model.InspectionLevel.TARGETED =>
      val r = TARGETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.InspectionLevel {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.InspectionLevel =
      software.amazon.awssdk.services.wafv2.model.InspectionLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object COMMON extends zio.aws.wafv2.model.InspectionLevel {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.InspectionLevel =
      software.amazon.awssdk.services.wafv2.model.InspectionLevel.COMMON
  }
  case object TARGETED extends zio.aws.wafv2.model.InspectionLevel {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.InspectionLevel =
      software.amazon.awssdk.services.wafv2.model.InspectionLevel.TARGETED
  }
}
