package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.FieldIdentifier
import scala.jdk.CollectionConverters._
final case class AddressField(identifier: FieldIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.AddressField = {
    import AddressField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.AddressField
      .builder()
      .identifier(FieldIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.AddressField.ReadOnly =
    zio.aws.wafv2.model.AddressField.wrap(buildAwsValue())
}
object AddressField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.AddressField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.AddressField =
      zio.aws.wafv2.model.AddressField(identifier)
    def identifier: FieldIdentifier
    def getIdentifier: ZIO[Any, Nothing, FieldIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.AddressField
  ) extends zio.aws.wafv2.model.AddressField.ReadOnly {
    override val identifier: FieldIdentifier =
      zio.aws.wafv2.model.primitives.FieldIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.AddressField
  ): zio.aws.wafv2.model.AddressField.ReadOnly = new Wrapper(impl)
}
