package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.{
  FailureValue,
  SuccessValue,
  ResponseInspectionHeaderName
}
import scala.jdk.CollectionConverters._
final case class ResponseInspectionHeader(
    name: ResponseInspectionHeaderName,
    successValues: Iterable[SuccessValue],
    failureValues: Iterable[FailureValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ResponseInspectionHeader = {
    import ResponseInspectionHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ResponseInspectionHeader
      .builder()
      .name(ResponseInspectionHeaderName.unwrap(name): java.lang.String)
      .successValues(successValues.map { item =>
        SuccessValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .failureValues(failureValues.map { item =>
        FailureValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ResponseInspectionHeader.ReadOnly =
    zio.aws.wafv2.model.ResponseInspectionHeader.wrap(buildAwsValue())
}
object ResponseInspectionHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ResponseInspectionHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ResponseInspectionHeader =
      zio.aws.wafv2.model
        .ResponseInspectionHeader(name, successValues, failureValues)
    def name: ResponseInspectionHeaderName
    def successValues: List[SuccessValue]
    def failureValues: List[FailureValue]
    def getName: ZIO[Any, Nothing, ResponseInspectionHeaderName] =
      ZIO.succeed(name)
    def getSuccessValues: ZIO[Any, Nothing, List[SuccessValue]] =
      ZIO.succeed(successValues)
    def getFailureValues: ZIO[Any, Nothing, List[FailureValue]] =
      ZIO.succeed(failureValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ResponseInspectionHeader
  ) extends zio.aws.wafv2.model.ResponseInspectionHeader.ReadOnly {
    override val name: ResponseInspectionHeaderName =
      zio.aws.wafv2.model.primitives.ResponseInspectionHeaderName(impl.name())
    override val successValues: List[SuccessValue] = impl
      .successValues()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.SuccessValue(item)
      }
      .toList
    override val failureValues: List[FailureValue] = impl
      .failureValues()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.FailureValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ResponseInspectionHeader
  ): zio.aws.wafv2.model.ResponseInspectionHeader.ReadOnly = new Wrapper(impl)
}
