package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RequestInspection(
    payloadType: zio.aws.wafv2.model.PayloadType,
    usernameField: zio.aws.wafv2.model.UsernameField,
    passwordField: zio.aws.wafv2.model.PasswordField
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RequestInspection = {
    import RequestInspection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RequestInspection
      .builder()
      .payloadType(payloadType.unwrap)
      .usernameField(usernameField.buildAwsValue())
      .passwordField(passwordField.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RequestInspection.ReadOnly =
    zio.aws.wafv2.model.RequestInspection.wrap(buildAwsValue())
}
object RequestInspection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RequestInspection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RequestInspection =
      zio.aws.wafv2.model.RequestInspection(
        payloadType,
        usernameField.asEditable,
        passwordField.asEditable
      )
    def payloadType: zio.aws.wafv2.model.PayloadType
    def usernameField: zio.aws.wafv2.model.UsernameField.ReadOnly
    def passwordField: zio.aws.wafv2.model.PasswordField.ReadOnly
    def getPayloadType: ZIO[Any, Nothing, zio.aws.wafv2.model.PayloadType] =
      ZIO.succeed(payloadType)
    def getUsernameField
        : ZIO[Any, Nothing, zio.aws.wafv2.model.UsernameField.ReadOnly] =
      ZIO.succeed(usernameField)
    def getPasswordField
        : ZIO[Any, Nothing, zio.aws.wafv2.model.PasswordField.ReadOnly] =
      ZIO.succeed(passwordField)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RequestInspection
  ) extends zio.aws.wafv2.model.RequestInspection.ReadOnly {
    override val payloadType: zio.aws.wafv2.model.PayloadType =
      zio.aws.wafv2.model.PayloadType.wrap(impl.payloadType())
    override val usernameField: zio.aws.wafv2.model.UsernameField.ReadOnly =
      zio.aws.wafv2.model.UsernameField.wrap(impl.usernameField())
    override val passwordField: zio.aws.wafv2.model.PasswordField.ReadOnly =
      zio.aws.wafv2.model.PasswordField.wrap(impl.passwordField())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RequestInspection
  ): zio.aws.wafv2.model.RequestInspection.ReadOnly = new Wrapper(impl)
}
