package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.RateLimit
import scala.jdk.CollectionConverters._
final case class RateBasedStatement(
    limit: RateLimit,
    aggregateKeyType: zio.aws.wafv2.model.RateBasedStatementAggregateKeyType,
    scopeDownStatement: Optional[zio.aws.wafv2.model.Statement] =
      Optional.Absent,
    forwardedIPConfig: Optional[zio.aws.wafv2.model.ForwardedIPConfig] =
      Optional.Absent,
    customKeys: Optional[
      Iterable[zio.aws.wafv2.model.RateBasedStatementCustomKey]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RateBasedStatement = {
    import RateBasedStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RateBasedStatement
      .builder()
      .limit(RateLimit.unwrap(limit): java.lang.Long)
      .aggregateKeyType(aggregateKeyType.unwrap)
      .optionallyWith(scopeDownStatement.map(value => value.buildAwsValue()))(
        _.scopeDownStatement
      )
      .optionallyWith(forwardedIPConfig.map(value => value.buildAwsValue()))(
        _.forwardedIPConfig
      )
      .optionallyWith(
        customKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customKeys)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RateBasedStatement.ReadOnly =
    zio.aws.wafv2.model.RateBasedStatement.wrap(buildAwsValue())
}
object RateBasedStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RateBasedStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RateBasedStatement =
      zio.aws.wafv2.model.RateBasedStatement(
        limit,
        aggregateKeyType,
        scopeDownStatement.map(value => value.asEditable),
        forwardedIPConfig.map(value => value.asEditable),
        customKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def limit: RateLimit
    def aggregateKeyType: zio.aws.wafv2.model.RateBasedStatementAggregateKeyType
    def scopeDownStatement: Optional[zio.aws.wafv2.model.Statement.ReadOnly]
    def forwardedIPConfig
        : Optional[zio.aws.wafv2.model.ForwardedIPConfig.ReadOnly]
    def customKeys: Optional[
      List[zio.aws.wafv2.model.RateBasedStatementCustomKey.ReadOnly]
    ]
    def getLimit: ZIO[Any, Nothing, RateLimit] = ZIO.succeed(limit)
    def getAggregateKeyType: ZIO[
      Any,
      Nothing,
      zio.aws.wafv2.model.RateBasedStatementAggregateKeyType
    ] = ZIO.succeed(aggregateKeyType)
    def getScopeDownStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.Statement.ReadOnly] =
      AwsError.unwrapOptionField("scopeDownStatement", scopeDownStatement)
    def getForwardedIPConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ForwardedIPConfig.ReadOnly] =
      AwsError.unwrapOptionField("forwardedIPConfig", forwardedIPConfig)
    def getCustomKeys: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.RateBasedStatementCustomKey.ReadOnly
    ]] = AwsError.unwrapOptionField("customKeys", customKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RateBasedStatement
  ) extends zio.aws.wafv2.model.RateBasedStatement.ReadOnly {
    override val limit: RateLimit =
      zio.aws.wafv2.model.primitives.RateLimit(impl.limit())
    override val aggregateKeyType
        : zio.aws.wafv2.model.RateBasedStatementAggregateKeyType =
      zio.aws.wafv2.model.RateBasedStatementAggregateKeyType
        .wrap(impl.aggregateKeyType())
    override val scopeDownStatement
        : Optional[zio.aws.wafv2.model.Statement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scopeDownStatement())
        .map(value => zio.aws.wafv2.model.Statement.wrap(value))
    override val forwardedIPConfig
        : Optional[zio.aws.wafv2.model.ForwardedIPConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forwardedIPConfig())
        .map(value => zio.aws.wafv2.model.ForwardedIPConfig.wrap(value))
    override val customKeys: Optional[
      List[zio.aws.wafv2.model.RateBasedStatementCustomKey.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.RateBasedStatementCustomKey.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RateBasedStatement
  ): zio.aws.wafv2.model.RateBasedStatement.ReadOnly = new Wrapper(impl)
}
