package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.LoginPathString
import scala.jdk.CollectionConverters._
final case class ManagedRuleGroupConfig(
    loginPath: Optional[LoginPathString] = Optional.Absent,
    payloadType: Optional[zio.aws.wafv2.model.PayloadType] = Optional.Absent,
    usernameField: Optional[zio.aws.wafv2.model.UsernameField] =
      Optional.Absent,
    passwordField: Optional[zio.aws.wafv2.model.PasswordField] =
      Optional.Absent,
    awsManagedRulesBotControlRuleSet: Optional[
      zio.aws.wafv2.model.AWSManagedRulesBotControlRuleSet
    ] = Optional.Absent,
    awsManagedRulesATPRuleSet: Optional[
      zio.aws.wafv2.model.AWSManagedRulesATPRuleSet
    ] = Optional.Absent,
    awsManagedRulesACFPRuleSet: Optional[
      zio.aws.wafv2.model.AWSManagedRulesACFPRuleSet
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupConfig = {
    import ManagedRuleGroupConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupConfig
      .builder()
      .optionallyWith(
        loginPath.map(value => LoginPathString.unwrap(value): java.lang.String)
      )(_.loginPath)
      .optionallyWith(payloadType.map(value => value.unwrap))(_.payloadType)
      .optionallyWith(usernameField.map(value => value.buildAwsValue()))(
        _.usernameField
      )
      .optionallyWith(passwordField.map(value => value.buildAwsValue()))(
        _.passwordField
      )
      .optionallyWith(
        awsManagedRulesBotControlRuleSet.map(value => value.buildAwsValue())
      )(_.awsManagedRulesBotControlRuleSet)
      .optionallyWith(
        awsManagedRulesATPRuleSet.map(value => value.buildAwsValue())
      )(_.awsManagedRulesATPRuleSet)
      .optionallyWith(
        awsManagedRulesACFPRuleSet.map(value => value.buildAwsValue())
      )(_.awsManagedRulesACFPRuleSet)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ManagedRuleGroupConfig.ReadOnly =
    zio.aws.wafv2.model.ManagedRuleGroupConfig.wrap(buildAwsValue())
}
object ManagedRuleGroupConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ManagedRuleGroupConfig =
      zio.aws.wafv2.model.ManagedRuleGroupConfig(
        loginPath.map(value => value),
        payloadType.map(value => value),
        usernameField.map(value => value.asEditable),
        passwordField.map(value => value.asEditable),
        awsManagedRulesBotControlRuleSet.map(value => value.asEditable),
        awsManagedRulesATPRuleSet.map(value => value.asEditable),
        awsManagedRulesACFPRuleSet.map(value => value.asEditable)
      )
    def loginPath: Optional[LoginPathString]
    def payloadType: Optional[zio.aws.wafv2.model.PayloadType]
    def usernameField: Optional[zio.aws.wafv2.model.UsernameField.ReadOnly]
    def passwordField: Optional[zio.aws.wafv2.model.PasswordField.ReadOnly]
    def awsManagedRulesBotControlRuleSet: Optional[
      zio.aws.wafv2.model.AWSManagedRulesBotControlRuleSet.ReadOnly
    ]
    def awsManagedRulesATPRuleSet
        : Optional[zio.aws.wafv2.model.AWSManagedRulesATPRuleSet.ReadOnly]
    def awsManagedRulesACFPRuleSet
        : Optional[zio.aws.wafv2.model.AWSManagedRulesACFPRuleSet.ReadOnly]
    def getLoginPath: ZIO[Any, AwsError, LoginPathString] =
      AwsError.unwrapOptionField("loginPath", loginPath)
    def getPayloadType: ZIO[Any, AwsError, zio.aws.wafv2.model.PayloadType] =
      AwsError.unwrapOptionField("payloadType", payloadType)
    def getUsernameField
        : ZIO[Any, AwsError, zio.aws.wafv2.model.UsernameField.ReadOnly] =
      AwsError.unwrapOptionField("usernameField", usernameField)
    def getPasswordField
        : ZIO[Any, AwsError, zio.aws.wafv2.model.PasswordField.ReadOnly] =
      AwsError.unwrapOptionField("passwordField", passwordField)
    def getAwsManagedRulesBotControlRuleSet: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.AWSManagedRulesBotControlRuleSet.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsManagedRulesBotControlRuleSet",
      awsManagedRulesBotControlRuleSet
    )
    def getAwsManagedRulesATPRuleSet: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.AWSManagedRulesATPRuleSet.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsManagedRulesATPRuleSet",
      awsManagedRulesATPRuleSet
    )
    def getAwsManagedRulesACFPRuleSet: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.AWSManagedRulesACFPRuleSet.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsManagedRulesACFPRuleSet",
      awsManagedRulesACFPRuleSet
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupConfig
  ) extends zio.aws.wafv2.model.ManagedRuleGroupConfig.ReadOnly {
    override val loginPath: Optional[LoginPathString] = zio.aws.core.internal
      .optionalFromNullable(impl.loginPath())
      .map(value => zio.aws.wafv2.model.primitives.LoginPathString(value))
    override val payloadType: Optional[zio.aws.wafv2.model.PayloadType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.payloadType())
        .map(value => zio.aws.wafv2.model.PayloadType.wrap(value))
    override val usernameField
        : Optional[zio.aws.wafv2.model.UsernameField.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usernameField())
        .map(value => zio.aws.wafv2.model.UsernameField.wrap(value))
    override val passwordField
        : Optional[zio.aws.wafv2.model.PasswordField.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.passwordField())
        .map(value => zio.aws.wafv2.model.PasswordField.wrap(value))
    override val awsManagedRulesBotControlRuleSet: Optional[
      zio.aws.wafv2.model.AWSManagedRulesBotControlRuleSet.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.awsManagedRulesBotControlRuleSet())
      .map(value =>
        zio.aws.wafv2.model.AWSManagedRulesBotControlRuleSet.wrap(value)
      )
    override val awsManagedRulesATPRuleSet
        : Optional[zio.aws.wafv2.model.AWSManagedRulesATPRuleSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsManagedRulesATPRuleSet())
        .map(value => zio.aws.wafv2.model.AWSManagedRulesATPRuleSet.wrap(value))
    override val awsManagedRulesACFPRuleSet
        : Optional[zio.aws.wafv2.model.AWSManagedRulesACFPRuleSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsManagedRulesACFPRuleSet())
        .map(value =>
          zio.aws.wafv2.model.AWSManagedRulesACFPRuleSet.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupConfig
  ): zio.aws.wafv2.model.ManagedRuleGroupConfig.ReadOnly = new Wrapper(impl)
}
