package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class IPSetReferenceStatement(
    arn: ResourceArn,
    ipSetForwardedIPConfig: Optional[
      zio.aws.wafv2.model.IPSetForwardedIPConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.IPSetReferenceStatement = {
    import IPSetReferenceStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.IPSetReferenceStatement
      .builder()
      .arn(ResourceArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        ipSetForwardedIPConfig.map(value => value.buildAwsValue())
      )(_.ipSetForwardedIPConfig)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.IPSetReferenceStatement.ReadOnly =
    zio.aws.wafv2.model.IPSetReferenceStatement.wrap(buildAwsValue())
}
object IPSetReferenceStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.IPSetReferenceStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.IPSetReferenceStatement =
      zio.aws.wafv2.model.IPSetReferenceStatement(
        arn,
        ipSetForwardedIPConfig.map(value => value.asEditable)
      )
    def arn: ResourceArn
    def ipSetForwardedIPConfig
        : Optional[zio.aws.wafv2.model.IPSetForwardedIPConfig.ReadOnly]
    def getArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(arn)
    def getIpSetForwardedIPConfig: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.IPSetForwardedIPConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ipSetForwardedIPConfig",
      ipSetForwardedIPConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.IPSetReferenceStatement
  ) extends zio.aws.wafv2.model.IPSetReferenceStatement.ReadOnly {
    override val arn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.arn())
    override val ipSetForwardedIPConfig
        : Optional[zio.aws.wafv2.model.IPSetForwardedIPConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipSetForwardedIPConfig())
        .map(value => zio.aws.wafv2.model.IPSetForwardedIPConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.IPSetReferenceStatement
  ): zio.aws.wafv2.model.IPSetReferenceStatement.ReadOnly = new Wrapper(impl)
}
