package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{Timestamp, TokenDomain}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetDecryptedApiKeyResponse(
    tokenDomains: Optional[Iterable[TokenDomain]] = Optional.Absent,
    creationTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyResponse = {
    import GetDecryptedApiKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyResponse
      .builder()
      .optionallyWith(
        tokenDomains.map(value =>
          value.map { item =>
            TokenDomain.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tokenDomains)
      .optionallyWith(
        creationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetDecryptedApiKeyResponse.ReadOnly =
    zio.aws.wafv2.model.GetDecryptedApiKeyResponse.wrap(buildAwsValue())
}
object GetDecryptedApiKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetDecryptedApiKeyResponse =
      zio.aws.wafv2.model.GetDecryptedApiKeyResponse(
        tokenDomains.map(value => value),
        creationTimestamp.map(value => value)
      )
    def tokenDomains: Optional[List[TokenDomain]]
    def creationTimestamp: Optional[Timestamp]
    def getTokenDomains: ZIO[Any, AwsError, List[TokenDomain]] =
      AwsError.unwrapOptionField("tokenDomains", tokenDomains)
    def getCreationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyResponse
  ) extends zio.aws.wafv2.model.GetDecryptedApiKeyResponse.ReadOnly {
    override val tokenDomains: Optional[List[TokenDomain]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tokenDomains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.primitives.TokenDomain(item)
          }.toList
        )
    override val creationTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyResponse
  ): zio.aws.wafv2.model.GetDecryptedApiKeyResponse.ReadOnly = new Wrapper(impl)
}
