package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ActionCondition(action: zio.aws.wafv2.model.ActionValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ActionCondition = {
    import ActionCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ActionCondition
      .builder()
      .action(action.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ActionCondition.ReadOnly =
    zio.aws.wafv2.model.ActionCondition.wrap(buildAwsValue())
}
object ActionCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ActionCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ActionCondition =
      zio.aws.wafv2.model.ActionCondition(action)
    def action: zio.aws.wafv2.model.ActionValue
    def getAction: ZIO[Any, Nothing, zio.aws.wafv2.model.ActionValue] =
      ZIO.succeed(action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ActionCondition
  ) extends zio.aws.wafv2.model.ActionCondition.ReadOnly {
    override val action: zio.aws.wafv2.model.ActionValue =
      zio.aws.wafv2.model.ActionValue.wrap(impl.action())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ActionCondition
  ): zio.aws.wafv2.model.ActionCondition.ReadOnly = new Wrapper(impl)
}
