package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.FieldIdentifier
import scala.jdk.CollectionConverters._
final case class UsernameField(identifier: FieldIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.UsernameField = {
    import UsernameField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.UsernameField
      .builder()
      .identifier(FieldIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.UsernameField.ReadOnly =
    zio.aws.wafv2.model.UsernameField.wrap(buildAwsValue())
}
object UsernameField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.UsernameField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.UsernameField =
      zio.aws.wafv2.model.UsernameField(identifier)
    def identifier: FieldIdentifier
    def getIdentifier: ZIO[Any, Nothing, FieldIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.UsernameField
  ) extends zio.aws.wafv2.model.UsernameField.ReadOnly {
    override val identifier: FieldIdentifier =
      zio.aws.wafv2.model.primitives.FieldIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.UsernameField
  ): zio.aws.wafv2.model.UsernameField.ReadOnly = new Wrapper(impl)
}
