package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.FieldToMatchData
import scala.jdk.CollectionConverters._
final case class RateLimitHeader(
    name: FieldToMatchData,
    textTransformations: Iterable[zio.aws.wafv2.model.TextTransformation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RateLimitHeader = {
    import RateLimitHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RateLimitHeader
      .builder()
      .name(FieldToMatchData.unwrap(name): java.lang.String)
      .textTransformations(textTransformations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RateLimitHeader.ReadOnly =
    zio.aws.wafv2.model.RateLimitHeader.wrap(buildAwsValue())
}
object RateLimitHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RateLimitHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RateLimitHeader =
      zio.aws.wafv2.model.RateLimitHeader(
        name,
        textTransformations.map { item =>
          item.asEditable
        }
      )
    def name: FieldToMatchData
    def textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly]
    def getName: ZIO[Any, Nothing, FieldToMatchData] = ZIO.succeed(name)
    def getTextTransformations: ZIO[Any, Nothing, List[
      zio.aws.wafv2.model.TextTransformation.ReadOnly
    ]] = ZIO.succeed(textTransformations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RateLimitHeader
  ) extends zio.aws.wafv2.model.RateLimitHeader.ReadOnly {
    override val name: FieldToMatchData =
      zio.aws.wafv2.model.primitives.FieldToMatchData(impl.name())
    override val textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly] = impl
      .textTransformations()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.TextTransformation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RateLimitHeader
  ): zio.aws.wafv2.model.RateLimitHeader.ReadOnly = new Wrapper(impl)
}
