package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAllManagedProductsResponse(
    managedProducts: Optional[
      Iterable[zio.aws.wafv2.model.ManagedProductDescriptor]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DescribeAllManagedProductsResponse = {
    import DescribeAllManagedProductsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DescribeAllManagedProductsResponse
      .builder()
      .optionallyWith(
        managedProducts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedProducts)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.DescribeAllManagedProductsResponse.ReadOnly =
    zio.aws.wafv2.model.DescribeAllManagedProductsResponse.wrap(buildAwsValue())
}
object DescribeAllManagedProductsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DescribeAllManagedProductsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.DescribeAllManagedProductsResponse =
      zio.aws.wafv2.model.DescribeAllManagedProductsResponse(
        managedProducts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def managedProducts
        : Optional[List[zio.aws.wafv2.model.ManagedProductDescriptor.ReadOnly]]
    def getManagedProducts: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.ManagedProductDescriptor.ReadOnly
    ]] = AwsError.unwrapOptionField("managedProducts", managedProducts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DescribeAllManagedProductsResponse
  ) extends zio.aws.wafv2.model.DescribeAllManagedProductsResponse.ReadOnly {
    override val managedProducts: Optional[
      List[zio.aws.wafv2.model.ManagedProductDescriptor.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.managedProducts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.ManagedProductDescriptor.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DescribeAllManagedProductsResponse
  ): zio.aws.wafv2.model.DescribeAllManagedProductsResponse.ReadOnly =
    new Wrapper(impl)
}
