package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.SearchString
import scala.jdk.CollectionConverters._
final case class ByteMatchStatement(
    searchString: SearchString,
    fieldToMatch: zio.aws.wafv2.model.FieldToMatch,
    textTransformations: Iterable[zio.aws.wafv2.model.TextTransformation],
    positionalConstraint: zio.aws.wafv2.model.PositionalConstraint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ByteMatchStatement = {
    import ByteMatchStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ByteMatchStatement
      .builder()
      .searchString(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(searchString.toArray[Byte])
      )
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformations(textTransformations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .positionalConstraint(positionalConstraint.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ByteMatchStatement.ReadOnly =
    zio.aws.wafv2.model.ByteMatchStatement.wrap(buildAwsValue())
}
object ByteMatchStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ByteMatchStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ByteMatchStatement =
      zio.aws.wafv2.model.ByteMatchStatement(
        searchString,
        fieldToMatch.asEditable,
        textTransformations.map { item =>
          item.asEditable
        },
        positionalConstraint
      )
    def searchString: SearchString
    def fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly
    def textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly]
    def positionalConstraint: zio.aws.wafv2.model.PositionalConstraint
    def getSearchString: ZIO[Any, Nothing, SearchString] =
      ZIO.succeed(searchString)
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.wafv2.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformations: ZIO[Any, Nothing, List[
      zio.aws.wafv2.model.TextTransformation.ReadOnly
    ]] = ZIO.succeed(textTransformations)
    def getPositionalConstraint
        : ZIO[Any, Nothing, zio.aws.wafv2.model.PositionalConstraint] =
      ZIO.succeed(positionalConstraint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ByteMatchStatement
  ) extends zio.aws.wafv2.model.ByteMatchStatement.ReadOnly {
    override val searchString: SearchString =
      zio.aws.wafv2.model.primitives.SearchString(
        zio.Chunk.fromArray(impl.searchString().asByteArrayUnsafe())
      )
    override val fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly =
      zio.aws.wafv2.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly] = impl
      .textTransformations()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.TextTransformation.wrap(item)
      }
      .toList
    override val positionalConstraint
        : zio.aws.wafv2.model.PositionalConstraint =
      zio.aws.wafv2.model.PositionalConstraint.wrap(impl.positionalConstraint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ByteMatchStatement
  ): zio.aws.wafv2.model.ByteMatchStatement.ReadOnly = new Wrapper(impl)
}
