package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.LockToken
import scala.jdk.CollectionConverters._
final case class UpdateIpSetResponse(
    nextLockToken: Optional[LockToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.UpdateIpSetResponse = {
    import UpdateIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.UpdateIpSetResponse
      .builder()
      .optionallyWith(
        nextLockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.nextLockToken)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.UpdateIpSetResponse.ReadOnly =
    zio.aws.wafv2.model.UpdateIpSetResponse.wrap(buildAwsValue())
}
object UpdateIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.UpdateIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.UpdateIpSetResponse =
      zio.aws.wafv2.model.UpdateIpSetResponse(nextLockToken.map(value => value))
    def nextLockToken: Optional[LockToken]
    def getNextLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("nextLockToken", nextLockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateIpSetResponse
  ) extends zio.aws.wafv2.model.UpdateIpSetResponse.ReadOnly {
    override val nextLockToken: Optional[LockToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextLockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateIpSetResponse
  ): zio.aws.wafv2.model.UpdateIpSetResponse.ReadOnly = new Wrapper(impl)
}
