package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.TokenDomain
import scala.jdk.CollectionConverters._
final case class CreateApiKeyRequest(
    scope: zio.aws.wafv2.model.Scope,
    tokenDomains: Iterable[TokenDomain]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CreateApiKeyRequest = {
    import CreateApiKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CreateApiKeyRequest
      .builder()
      .scope(scope.unwrap)
      .tokenDomains(tokenDomains.map { item =>
        TokenDomain.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CreateApiKeyRequest.ReadOnly =
    zio.aws.wafv2.model.CreateApiKeyRequest.wrap(buildAwsValue())
}
object CreateApiKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CreateApiKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CreateApiKeyRequest =
      zio.aws.wafv2.model.CreateApiKeyRequest(scope, tokenDomains)
    def scope: zio.aws.wafv2.model.Scope
    def tokenDomains: List[TokenDomain]
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getTokenDomains: ZIO[Any, Nothing, List[TokenDomain]] =
      ZIO.succeed(tokenDomains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CreateApiKeyRequest
  ) extends zio.aws.wafv2.model.CreateApiKeyRequest.ReadOnly {
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val tokenDomains: List[TokenDomain] = impl
      .tokenDomains()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.TokenDomain(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CreateApiKeyRequest
  ): zio.aws.wafv2.model.CreateApiKeyRequest.ReadOnly = new Wrapper(impl)
}
