package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class AssociateWebAclRequest(
    webACLArn: ResourceArn,
    resourceArn: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.AssociateWebAclRequest = {
    import AssociateWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.AssociateWebAclRequest
      .builder()
      .webACLArn(ResourceArn.unwrap(webACLArn): java.lang.String)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.AssociateWebAclRequest.ReadOnly =
    zio.aws.wafv2.model.AssociateWebAclRequest.wrap(buildAwsValue())
}
object AssociateWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.AssociateWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.AssociateWebAclRequest =
      zio.aws.wafv2.model.AssociateWebAclRequest(webACLArn, resourceArn)
    def webACLArn: ResourceArn
    def resourceArn: ResourceArn
    def getWebACLArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(webACLArn)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.AssociateWebAclRequest
  ) extends zio.aws.wafv2.model.AssociateWebAclRequest.ReadOnly {
    override val webACLArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.webACLArn())
    override val resourceArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.AssociateWebAclRequest
  ): zio.aws.wafv2.model.AssociateWebAclRequest.ReadOnly = new Wrapper(impl)
}
