package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AWSManagedRulesATPRuleSet(
    loginPath: String,
    requestInspection: Optional[zio.aws.wafv2.model.RequestInspection] =
      Optional.Absent,
    responseInspection: Optional[zio.aws.wafv2.model.ResponseInspection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.AWSManagedRulesATPRuleSet = {
    import AWSManagedRulesATPRuleSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.AWSManagedRulesATPRuleSet
      .builder()
      .loginPath(loginPath: java.lang.String)
      .optionallyWith(requestInspection.map(value => value.buildAwsValue()))(
        _.requestInspection
      )
      .optionallyWith(responseInspection.map(value => value.buildAwsValue()))(
        _.responseInspection
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.AWSManagedRulesATPRuleSet.ReadOnly =
    zio.aws.wafv2.model.AWSManagedRulesATPRuleSet.wrap(buildAwsValue())
}
object AWSManagedRulesATPRuleSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.AWSManagedRulesATPRuleSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.AWSManagedRulesATPRuleSet =
      zio.aws.wafv2.model.AWSManagedRulesATPRuleSet(
        loginPath,
        requestInspection.map(value => value.asEditable),
        responseInspection.map(value => value.asEditable)
      )
    def loginPath: String
    def requestInspection
        : Optional[zio.aws.wafv2.model.RequestInspection.ReadOnly]
    def responseInspection
        : Optional[zio.aws.wafv2.model.ResponseInspection.ReadOnly]
    def getLoginPath: ZIO[Any, Nothing, String] = ZIO.succeed(loginPath)
    def getRequestInspection
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RequestInspection.ReadOnly] =
      AwsError.unwrapOptionField("requestInspection", requestInspection)
    def getResponseInspection
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ResponseInspection.ReadOnly] =
      AwsError.unwrapOptionField("responseInspection", responseInspection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.AWSManagedRulesATPRuleSet
  ) extends zio.aws.wafv2.model.AWSManagedRulesATPRuleSet.ReadOnly {
    override val loginPath: String = impl.loginPath(): String
    override val requestInspection
        : Optional[zio.aws.wafv2.model.RequestInspection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestInspection())
        .map(value => zio.aws.wafv2.model.RequestInspection.wrap(value))
    override val responseInspection
        : Optional[zio.aws.wafv2.model.ResponseInspection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseInspection())
        .map(value => zio.aws.wafv2.model.ResponseInspection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.AWSManagedRulesATPRuleSet
  ): zio.aws.wafv2.model.AWSManagedRulesATPRuleSet.ReadOnly = new Wrapper(impl)
}
