package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Statement(
    byteMatchStatement: Optional[zio.aws.wafv2.model.ByteMatchStatement] =
      Optional.Absent,
    sqliMatchStatement: Optional[zio.aws.wafv2.model.SqliMatchStatement] =
      Optional.Absent,
    xssMatchStatement: Optional[zio.aws.wafv2.model.XssMatchStatement] =
      Optional.Absent,
    sizeConstraintStatement: Optional[
      zio.aws.wafv2.model.SizeConstraintStatement
    ] = Optional.Absent,
    geoMatchStatement: Optional[zio.aws.wafv2.model.GeoMatchStatement] =
      Optional.Absent,
    ruleGroupReferenceStatement: Optional[
      zio.aws.wafv2.model.RuleGroupReferenceStatement
    ] = Optional.Absent,
    ipSetReferenceStatement: Optional[
      zio.aws.wafv2.model.IPSetReferenceStatement
    ] = Optional.Absent,
    regexPatternSetReferenceStatement: Optional[
      zio.aws.wafv2.model.RegexPatternSetReferenceStatement
    ] = Optional.Absent,
    rateBasedStatement: Optional[zio.aws.wafv2.model.RateBasedStatement] =
      Optional.Absent,
    andStatement: Optional[zio.aws.wafv2.model.AndStatement] = Optional.Absent,
    orStatement: Optional[zio.aws.wafv2.model.OrStatement] = Optional.Absent,
    notStatement: Optional[zio.aws.wafv2.model.NotStatement] = Optional.Absent,
    managedRuleGroupStatement: Optional[
      zio.aws.wafv2.model.ManagedRuleGroupStatement
    ] = Optional.Absent,
    labelMatchStatement: Optional[zio.aws.wafv2.model.LabelMatchStatement] =
      Optional.Absent,
    regexMatchStatement: Optional[zio.aws.wafv2.model.RegexMatchStatement] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.Statement = {
    import Statement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.Statement
      .builder()
      .optionallyWith(byteMatchStatement.map(value => value.buildAwsValue()))(
        _.byteMatchStatement
      )
      .optionallyWith(sqliMatchStatement.map(value => value.buildAwsValue()))(
        _.sqliMatchStatement
      )
      .optionallyWith(xssMatchStatement.map(value => value.buildAwsValue()))(
        _.xssMatchStatement
      )
      .optionallyWith(
        sizeConstraintStatement.map(value => value.buildAwsValue())
      )(_.sizeConstraintStatement)
      .optionallyWith(geoMatchStatement.map(value => value.buildAwsValue()))(
        _.geoMatchStatement
      )
      .optionallyWith(
        ruleGroupReferenceStatement.map(value => value.buildAwsValue())
      )(_.ruleGroupReferenceStatement)
      .optionallyWith(
        ipSetReferenceStatement.map(value => value.buildAwsValue())
      )(_.ipSetReferenceStatement)
      .optionallyWith(
        regexPatternSetReferenceStatement.map(value => value.buildAwsValue())
      )(_.regexPatternSetReferenceStatement)
      .optionallyWith(rateBasedStatement.map(value => value.buildAwsValue()))(
        _.rateBasedStatement
      )
      .optionallyWith(andStatement.map(value => value.buildAwsValue()))(
        _.andStatement
      )
      .optionallyWith(orStatement.map(value => value.buildAwsValue()))(
        _.orStatement
      )
      .optionallyWith(notStatement.map(value => value.buildAwsValue()))(
        _.notStatement
      )
      .optionallyWith(
        managedRuleGroupStatement.map(value => value.buildAwsValue())
      )(_.managedRuleGroupStatement)
      .optionallyWith(labelMatchStatement.map(value => value.buildAwsValue()))(
        _.labelMatchStatement
      )
      .optionallyWith(regexMatchStatement.map(value => value.buildAwsValue()))(
        _.regexMatchStatement
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.Statement.ReadOnly =
    zio.aws.wafv2.model.Statement.wrap(buildAwsValue())
}
object Statement {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.Statement] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.Statement =
      zio.aws.wafv2.model.Statement(
        byteMatchStatement.map(value => value.asEditable),
        sqliMatchStatement.map(value => value.asEditable),
        xssMatchStatement.map(value => value.asEditable),
        sizeConstraintStatement.map(value => value.asEditable),
        geoMatchStatement.map(value => value.asEditable),
        ruleGroupReferenceStatement.map(value => value.asEditable),
        ipSetReferenceStatement.map(value => value.asEditable),
        regexPatternSetReferenceStatement.map(value => value.asEditable),
        rateBasedStatement.map(value => value.asEditable),
        andStatement.map(value => value.asEditable),
        orStatement.map(value => value.asEditable),
        notStatement.map(value => value.asEditable),
        managedRuleGroupStatement.map(value => value.asEditable),
        labelMatchStatement.map(value => value.asEditable),
        regexMatchStatement.map(value => value.asEditable)
      )
    def byteMatchStatement
        : Optional[zio.aws.wafv2.model.ByteMatchStatement.ReadOnly]
    def sqliMatchStatement
        : Optional[zio.aws.wafv2.model.SqliMatchStatement.ReadOnly]
    def xssMatchStatement
        : Optional[zio.aws.wafv2.model.XssMatchStatement.ReadOnly]
    def sizeConstraintStatement
        : Optional[zio.aws.wafv2.model.SizeConstraintStatement.ReadOnly]
    def geoMatchStatement
        : Optional[zio.aws.wafv2.model.GeoMatchStatement.ReadOnly]
    def ruleGroupReferenceStatement
        : Optional[zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly]
    def ipSetReferenceStatement
        : Optional[zio.aws.wafv2.model.IPSetReferenceStatement.ReadOnly]
    def regexPatternSetReferenceStatement: Optional[
      zio.aws.wafv2.model.RegexPatternSetReferenceStatement.ReadOnly
    ]
    def rateBasedStatement
        : Optional[zio.aws.wafv2.model.RateBasedStatement.ReadOnly]
    def andStatement: Optional[zio.aws.wafv2.model.AndStatement.ReadOnly]
    def orStatement: Optional[zio.aws.wafv2.model.OrStatement.ReadOnly]
    def notStatement: Optional[zio.aws.wafv2.model.NotStatement.ReadOnly]
    def managedRuleGroupStatement
        : Optional[zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly]
    def labelMatchStatement
        : Optional[zio.aws.wafv2.model.LabelMatchStatement.ReadOnly]
    def regexMatchStatement
        : Optional[zio.aws.wafv2.model.RegexMatchStatement.ReadOnly]
    def getByteMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ByteMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("byteMatchStatement", byteMatchStatement)
    def getSqliMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.SqliMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("sqliMatchStatement", sqliMatchStatement)
    def getXssMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.XssMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("xssMatchStatement", xssMatchStatement)
    def getSizeConstraintStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.SizeConstraintStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sizeConstraintStatement",
      sizeConstraintStatement
    )
    def getGeoMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.GeoMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("geoMatchStatement", geoMatchStatement)
    def getRuleGroupReferenceStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ruleGroupReferenceStatement",
      ruleGroupReferenceStatement
    )
    def getIpSetReferenceStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.IPSetReferenceStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ipSetReferenceStatement",
      ipSetReferenceStatement
    )
    def getRegexPatternSetReferenceStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RegexPatternSetReferenceStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "regexPatternSetReferenceStatement",
      regexPatternSetReferenceStatement
    )
    def getRateBasedStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RateBasedStatement.ReadOnly] =
      AwsError.unwrapOptionField("rateBasedStatement", rateBasedStatement)
    def getAndStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.AndStatement.ReadOnly] =
      AwsError.unwrapOptionField("andStatement", andStatement)
    def getOrStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.OrStatement.ReadOnly] =
      AwsError.unwrapOptionField("orStatement", orStatement)
    def getNotStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.NotStatement.ReadOnly] =
      AwsError.unwrapOptionField("notStatement", notStatement)
    def getManagedRuleGroupStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "managedRuleGroupStatement",
      managedRuleGroupStatement
    )
    def getLabelMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.LabelMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("labelMatchStatement", labelMatchStatement)
    def getRegexMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RegexMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("regexMatchStatement", regexMatchStatement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.Statement
  ) extends zio.aws.wafv2.model.Statement.ReadOnly {
    override val byteMatchStatement
        : Optional[zio.aws.wafv2.model.ByteMatchStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byteMatchStatement())
        .map(value => zio.aws.wafv2.model.ByteMatchStatement.wrap(value))
    override val sqliMatchStatement
        : Optional[zio.aws.wafv2.model.SqliMatchStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sqliMatchStatement())
        .map(value => zio.aws.wafv2.model.SqliMatchStatement.wrap(value))
    override val xssMatchStatement
        : Optional[zio.aws.wafv2.model.XssMatchStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xssMatchStatement())
        .map(value => zio.aws.wafv2.model.XssMatchStatement.wrap(value))
    override val sizeConstraintStatement
        : Optional[zio.aws.wafv2.model.SizeConstraintStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeConstraintStatement())
        .map(value => zio.aws.wafv2.model.SizeConstraintStatement.wrap(value))
    override val geoMatchStatement
        : Optional[zio.aws.wafv2.model.GeoMatchStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoMatchStatement())
        .map(value => zio.aws.wafv2.model.GeoMatchStatement.wrap(value))
    override val ruleGroupReferenceStatement
        : Optional[zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroupReferenceStatement())
        .map(value =>
          zio.aws.wafv2.model.RuleGroupReferenceStatement.wrap(value)
        )
    override val ipSetReferenceStatement
        : Optional[zio.aws.wafv2.model.IPSetReferenceStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipSetReferenceStatement())
        .map(value => zio.aws.wafv2.model.IPSetReferenceStatement.wrap(value))
    override val regexPatternSetReferenceStatement: Optional[
      zio.aws.wafv2.model.RegexPatternSetReferenceStatement.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.regexPatternSetReferenceStatement())
      .map(value =>
        zio.aws.wafv2.model.RegexPatternSetReferenceStatement.wrap(value)
      )
    override val rateBasedStatement
        : Optional[zio.aws.wafv2.model.RateBasedStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rateBasedStatement())
        .map(value => zio.aws.wafv2.model.RateBasedStatement.wrap(value))
    override val andStatement
        : Optional[zio.aws.wafv2.model.AndStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.andStatement())
        .map(value => zio.aws.wafv2.model.AndStatement.wrap(value))
    override val orStatement
        : Optional[zio.aws.wafv2.model.OrStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orStatement())
        .map(value => zio.aws.wafv2.model.OrStatement.wrap(value))
    override val notStatement
        : Optional[zio.aws.wafv2.model.NotStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notStatement())
        .map(value => zio.aws.wafv2.model.NotStatement.wrap(value))
    override val managedRuleGroupStatement
        : Optional[zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedRuleGroupStatement())
        .map(value => zio.aws.wafv2.model.ManagedRuleGroupStatement.wrap(value))
    override val labelMatchStatement
        : Optional[zio.aws.wafv2.model.LabelMatchStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelMatchStatement())
        .map(value => zio.aws.wafv2.model.LabelMatchStatement.wrap(value))
    override val regexMatchStatement
        : Optional[zio.aws.wafv2.model.RegexMatchStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regexMatchStatement())
        .map(value => zio.aws.wafv2.model.RegexMatchStatement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.Statement
  ): zio.aws.wafv2.model.Statement.ReadOnly = new Wrapper(impl)
}
