package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.FieldToMatchData
import scala.jdk.CollectionConverters._
final case class HeaderMatchPattern(
    all: Optional[zio.aws.wafv2.model.All] = Optional.Absent,
    includedHeaders: Optional[Iterable[FieldToMatchData]] = Optional.Absent,
    excludedHeaders: Optional[Iterable[FieldToMatchData]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.HeaderMatchPattern = {
    import HeaderMatchPattern.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.HeaderMatchPattern
      .builder()
      .optionallyWith(all.map(value => value.buildAwsValue()))(_.all)
      .optionallyWith(
        includedHeaders.map(value =>
          value.map { item =>
            FieldToMatchData.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.includedHeaders)
      .optionallyWith(
        excludedHeaders.map(value =>
          value.map { item =>
            FieldToMatchData.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedHeaders)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.HeaderMatchPattern.ReadOnly =
    zio.aws.wafv2.model.HeaderMatchPattern.wrap(buildAwsValue())
}
object HeaderMatchPattern {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.HeaderMatchPattern
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.HeaderMatchPattern =
      zio.aws.wafv2.model.HeaderMatchPattern(
        all.map(value => value.asEditable),
        includedHeaders.map(value => value),
        excludedHeaders.map(value => value)
      )
    def all: Optional[zio.aws.wafv2.model.All.ReadOnly]
    def includedHeaders: Optional[List[FieldToMatchData]]
    def excludedHeaders: Optional[List[FieldToMatchData]]
    def getAll: ZIO[Any, AwsError, zio.aws.wafv2.model.All.ReadOnly] =
      AwsError.unwrapOptionField("all", all)
    def getIncludedHeaders: ZIO[Any, AwsError, List[FieldToMatchData]] =
      AwsError.unwrapOptionField("includedHeaders", includedHeaders)
    def getExcludedHeaders: ZIO[Any, AwsError, List[FieldToMatchData]] =
      AwsError.unwrapOptionField("excludedHeaders", excludedHeaders)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.HeaderMatchPattern
  ) extends zio.aws.wafv2.model.HeaderMatchPattern.ReadOnly {
    override val all: Optional[zio.aws.wafv2.model.All.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.all())
        .map(value => zio.aws.wafv2.model.All.wrap(value))
    override val includedHeaders: Optional[List[FieldToMatchData]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includedHeaders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.primitives.FieldToMatchData(item)
          }.toList
        )
    override val excludedHeaders: Optional[List[FieldToMatchData]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludedHeaders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.primitives.FieldToMatchData(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.HeaderMatchPattern
  ): zio.aws.wafv2.model.HeaderMatchPattern.ReadOnly = new Wrapper(impl)
}
