package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FirewallManagerStatement(
    managedRuleGroupStatement: Optional[
      zio.aws.wafv2.model.ManagedRuleGroupStatement
    ] = Optional.Absent,
    ruleGroupReferenceStatement: Optional[
      zio.aws.wafv2.model.RuleGroupReferenceStatement
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.FirewallManagerStatement = {
    import FirewallManagerStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.FirewallManagerStatement
      .builder()
      .optionallyWith(
        managedRuleGroupStatement.map(value => value.buildAwsValue())
      )(_.managedRuleGroupStatement)
      .optionallyWith(
        ruleGroupReferenceStatement.map(value => value.buildAwsValue())
      )(_.ruleGroupReferenceStatement)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.FirewallManagerStatement.ReadOnly =
    zio.aws.wafv2.model.FirewallManagerStatement.wrap(buildAwsValue())
}
object FirewallManagerStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.FirewallManagerStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.FirewallManagerStatement =
      zio.aws.wafv2.model.FirewallManagerStatement(
        managedRuleGroupStatement.map(value => value.asEditable),
        ruleGroupReferenceStatement.map(value => value.asEditable)
      )
    def managedRuleGroupStatement
        : Optional[zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly]
    def ruleGroupReferenceStatement
        : Optional[zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly]
    def getManagedRuleGroupStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "managedRuleGroupStatement",
      managedRuleGroupStatement
    )
    def getRuleGroupReferenceStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ruleGroupReferenceStatement",
      ruleGroupReferenceStatement
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.FirewallManagerStatement
  ) extends zio.aws.wafv2.model.FirewallManagerStatement.ReadOnly {
    override val managedRuleGroupStatement
        : Optional[zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedRuleGroupStatement())
        .map(value => zio.aws.wafv2.model.ManagedRuleGroupStatement.wrap(value))
    override val ruleGroupReferenceStatement
        : Optional[zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroupReferenceStatement())
        .map(value =>
          zio.aws.wafv2.model.RuleGroupReferenceStatement.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.FirewallManagerStatement
  ): zio.aws.wafv2.model.FirewallManagerStatement.ReadOnly = new Wrapper(impl)
}
