package zio.aws.wafv2.model
import scala.jdk.CollectionConverters._
sealed trait FilterBehavior {
  def unwrap: software.amazon.awssdk.services.wafv2.model.FilterBehavior
}
object FilterBehavior {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.FilterBehavior
  ): zio.aws.wafv2.model.FilterBehavior = value match {
    case software.amazon.awssdk.services.wafv2.model.FilterBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.FilterBehavior.KEEP =>
      val r = KEEP
      r
    case software.amazon.awssdk.services.wafv2.model.FilterBehavior.DROP =>
      val r = DROP
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.FilterBehavior {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FilterBehavior =
      software.amazon.awssdk.services.wafv2.model.FilterBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object KEEP extends zio.aws.wafv2.model.FilterBehavior {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FilterBehavior =
      software.amazon.awssdk.services.wafv2.model.FilterBehavior.KEEP
  }
  case object DROP extends zio.aws.wafv2.model.FilterBehavior {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FilterBehavior =
      software.amazon.awssdk.services.wafv2.model.FilterBehavior.DROP
  }
}
