package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChallengeAction(
    customRequestHandling: Optional[zio.aws.wafv2.model.CustomRequestHandling] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ChallengeAction = {
    import ChallengeAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ChallengeAction
      .builder()
      .optionallyWith(
        customRequestHandling.map(value => value.buildAwsValue())
      )(_.customRequestHandling)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ChallengeAction.ReadOnly =
    zio.aws.wafv2.model.ChallengeAction.wrap(buildAwsValue())
}
object ChallengeAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ChallengeAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ChallengeAction = zio.aws.wafv2.model
      .ChallengeAction(customRequestHandling.map(value => value.asEditable))
    def customRequestHandling
        : Optional[zio.aws.wafv2.model.CustomRequestHandling.ReadOnly]
    def getCustomRequestHandling: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.CustomRequestHandling.ReadOnly
    ] =
      AwsError.unwrapOptionField("customRequestHandling", customRequestHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ChallengeAction
  ) extends zio.aws.wafv2.model.ChallengeAction.ReadOnly {
    override val customRequestHandling
        : Optional[zio.aws.wafv2.model.CustomRequestHandling.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customRequestHandling())
        .map(value => zio.aws.wafv2.model.CustomRequestHandling.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ChallengeAction
  ): zio.aws.wafv2.model.ChallengeAction.ReadOnly = new Wrapper(impl)
}
