package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class RuleActionOverride(
    name: EntityName,
    actionToUse: zio.aws.wafv2.model.RuleAction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RuleActionOverride = {
    import RuleActionOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RuleActionOverride
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .actionToUse(actionToUse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RuleActionOverride.ReadOnly =
    zio.aws.wafv2.model.RuleActionOverride.wrap(buildAwsValue())
}
object RuleActionOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RuleActionOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RuleActionOverride =
      zio.aws.wafv2.model.RuleActionOverride(name, actionToUse.asEditable)
    def name: EntityName
    def actionToUse: zio.aws.wafv2.model.RuleAction.ReadOnly
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getActionToUse
        : ZIO[Any, Nothing, zio.aws.wafv2.model.RuleAction.ReadOnly] =
      ZIO.succeed(actionToUse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RuleActionOverride
  ) extends zio.aws.wafv2.model.RuleActionOverride.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val actionToUse: zio.aws.wafv2.model.RuleAction.ReadOnly =
      zio.aws.wafv2.model.RuleAction.wrap(impl.actionToUse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RuleActionOverride
  ): zio.aws.wafv2.model.RuleActionOverride.ReadOnly = new Wrapper(impl)
}
