package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.TimeWindowSecond
import scala.jdk.CollectionConverters._
final case class ImmunityTimeProperty(immunityTime: TimeWindowSecond) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ImmunityTimeProperty = {
    import ImmunityTimeProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ImmunityTimeProperty
      .builder()
      .immunityTime(TimeWindowSecond.unwrap(immunityTime): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ImmunityTimeProperty.ReadOnly =
    zio.aws.wafv2.model.ImmunityTimeProperty.wrap(buildAwsValue())
}
object ImmunityTimeProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ImmunityTimeProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ImmunityTimeProperty =
      zio.aws.wafv2.model.ImmunityTimeProperty(immunityTime)
    def immunityTime: TimeWindowSecond
    def getImmunityTime: ZIO[Any, Nothing, TimeWindowSecond] =
      ZIO.succeed(immunityTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ImmunityTimeProperty
  ) extends zio.aws.wafv2.model.ImmunityTimeProperty.ReadOnly {
    override val immunityTime: TimeWindowSecond =
      zio.aws.wafv2.model.primitives.TimeWindowSecond(impl.immunityTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ImmunityTimeProperty
  ): zio.aws.wafv2.model.ImmunityTimeProperty.ReadOnly = new Wrapper(impl)
}
