package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  EntityDescription,
  EntityName,
  VendorName
}
import scala.jdk.CollectionConverters._
final case class ManagedRuleGroupSummary(
    vendorName: Optional[VendorName] = Optional.Absent,
    name: Optional[EntityName] = Optional.Absent,
    versioningSupported: Optional[Boolean] = Optional.Absent,
    description: Optional[EntityDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummary = {
    import ManagedRuleGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummary
      .builder()
      .optionallyWith(
        vendorName.map(value => VendorName.unwrap(value): java.lang.String)
      )(_.vendorName)
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        versioningSupported.map(value => value: java.lang.Boolean)
      )(_.versioningSupported)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ManagedRuleGroupSummary.ReadOnly =
    zio.aws.wafv2.model.ManagedRuleGroupSummary.wrap(buildAwsValue())
}
object ManagedRuleGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ManagedRuleGroupSummary =
      zio.aws.wafv2.model.ManagedRuleGroupSummary(
        vendorName.map(value => value),
        name.map(value => value),
        versioningSupported.map(value => value),
        description.map(value => value)
      )
    def vendorName: Optional[VendorName]
    def name: Optional[EntityName]
    def versioningSupported: Optional[Boolean]
    def description: Optional[EntityDescription]
    def getVendorName: ZIO[Any, AwsError, VendorName] =
      AwsError.unwrapOptionField("vendorName", vendorName)
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getVersioningSupported: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("versioningSupported", versioningSupported)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummary
  ) extends zio.aws.wafv2.model.ManagedRuleGroupSummary.ReadOnly {
    override val vendorName: Optional[VendorName] = zio.aws.core.internal
      .optionalFromNullable(impl.vendorName())
      .map(value => zio.aws.wafv2.model.primitives.VendorName(value))
    override val name: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val versioningSupported: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.versioningSupported())
      .map(value => value: Boolean)
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummary
  ): zio.aws.wafv2.model.ManagedRuleGroupSummary.ReadOnly = new Wrapper(impl)
}
