package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.{FailureValue, SuccessValue}
import scala.jdk.CollectionConverters._
final case class ResponseInspectionBodyContains(
    successStrings: Iterable[SuccessValue],
    failureStrings: Iterable[FailureValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ResponseInspectionBodyContains = {
    import ResponseInspectionBodyContains.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ResponseInspectionBodyContains
      .builder()
      .successStrings(successStrings.map { item =>
        SuccessValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .failureStrings(failureStrings.map { item =>
        FailureValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ResponseInspectionBodyContains.ReadOnly =
    zio.aws.wafv2.model.ResponseInspectionBodyContains.wrap(buildAwsValue())
}
object ResponseInspectionBodyContains {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ResponseInspectionBodyContains
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ResponseInspectionBodyContains =
      zio.aws.wafv2.model
        .ResponseInspectionBodyContains(successStrings, failureStrings)
    def successStrings: List[SuccessValue]
    def failureStrings: List[FailureValue]
    def getSuccessStrings: ZIO[Any, Nothing, List[SuccessValue]] =
      ZIO.succeed(successStrings)
    def getFailureStrings: ZIO[Any, Nothing, List[FailureValue]] =
      ZIO.succeed(failureStrings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ResponseInspectionBodyContains
  ) extends zio.aws.wafv2.model.ResponseInspectionBodyContains.ReadOnly {
    override val successStrings: List[SuccessValue] = impl
      .successStrings()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.SuccessValue(item)
      }
      .toList
    override val failureStrings: List[FailureValue] = impl
      .failureStrings()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.FailureValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ResponseInspectionBodyContains
  ): zio.aws.wafv2.model.ResponseInspectionBodyContains.ReadOnly = new Wrapper(
    impl
  )
}
