package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.LabelName
import scala.jdk.CollectionConverters._
final case class LabelNameCondition(labelName: LabelName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.LabelNameCondition = {
    import LabelNameCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.LabelNameCondition
      .builder()
      .labelName(LabelName.unwrap(labelName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.LabelNameCondition.ReadOnly =
    zio.aws.wafv2.model.LabelNameCondition.wrap(buildAwsValue())
}
object LabelNameCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.LabelNameCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.LabelNameCondition =
      zio.aws.wafv2.model.LabelNameCondition(labelName)
    def labelName: LabelName
    def getLabelName: ZIO[Any, Nothing, LabelName] = ZIO.succeed(labelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.LabelNameCondition
  ) extends zio.aws.wafv2.model.LabelNameCondition.ReadOnly {
    override val labelName: LabelName =
      zio.aws.wafv2.model.primitives.LabelName(impl.labelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.LabelNameCondition
  ): zio.aws.wafv2.model.LabelNameCondition.ReadOnly = new Wrapper(impl)
}
