package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class DeletePermissionPolicyRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyRequest = {
    import DeletePermissionPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.DeletePermissionPolicyRequest.ReadOnly =
    zio.aws.wafv2.model.DeletePermissionPolicyRequest.wrap(buildAwsValue())
}
object DeletePermissionPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.DeletePermissionPolicyRequest =
      zio.aws.wafv2.model.DeletePermissionPolicyRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyRequest
  ) extends zio.aws.wafv2.model.DeletePermissionPolicyRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyRequest
  ): zio.aws.wafv2.model.DeletePermissionPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
