package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.LockToken
import scala.jdk.CollectionConverters._
final case class GetManagedRuleSetResponse(
    managedRuleSet: Optional[zio.aws.wafv2.model.ManagedRuleSet] =
      Optional.Absent,
    lockToken: Optional[LockToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetManagedRuleSetResponse = {
    import GetManagedRuleSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetManagedRuleSetResponse
      .builder()
      .optionallyWith(managedRuleSet.map(value => value.buildAwsValue()))(
        _.managedRuleSet
      )
      .optionallyWith(
        lockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.lockToken)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetManagedRuleSetResponse.ReadOnly =
    zio.aws.wafv2.model.GetManagedRuleSetResponse.wrap(buildAwsValue())
}
object GetManagedRuleSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetManagedRuleSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetManagedRuleSetResponse =
      zio.aws.wafv2.model.GetManagedRuleSetResponse(
        managedRuleSet.map(value => value.asEditable),
        lockToken.map(value => value)
      )
    def managedRuleSet: Optional[zio.aws.wafv2.model.ManagedRuleSet.ReadOnly]
    def lockToken: Optional[LockToken]
    def getManagedRuleSet
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ManagedRuleSet.ReadOnly] =
      AwsError.unwrapOptionField("managedRuleSet", managedRuleSet)
    def getLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("lockToken", lockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetManagedRuleSetResponse
  ) extends zio.aws.wafv2.model.GetManagedRuleSetResponse.ReadOnly {
    override val managedRuleSet
        : Optional[zio.aws.wafv2.model.ManagedRuleSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedRuleSet())
        .map(value => zio.aws.wafv2.model.ManagedRuleSet.wrap(value))
    override val lockToken: Optional[LockToken] = zio.aws.core.internal
      .optionalFromNullable(impl.lockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetManagedRuleSetResponse
  ): zio.aws.wafv2.model.GetManagedRuleSetResponse.ReadOnly = new Wrapper(impl)
}
