package zio.aws.wafv2
import zio.aws.wafv2.model.primitives.ListMaxItems.Type
import zio.aws.wafv2.model.primitives.{
  JsonPointerPath,
  VersionKeyString,
  TokenDomain,
  FieldToMatchData,
  ResourceArn,
  SingleCookieName,
  EntityName,
  IPAddress,
  TagKey
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Action extends Subtype[String]
    type Action = zio.aws.wafv2.model.primitives.Action.Type
    object CapacityUnit extends Subtype[Long]
    type CapacityUnit = zio.aws.wafv2.model.primitives.CapacityUnit.Type
    object ConsumedCapacity extends Subtype[Long]
    type ConsumedCapacity = zio.aws.wafv2.model.primitives.ConsumedCapacity.Type
    object Country extends Subtype[String]
    type Country = zio.aws.wafv2.model.primitives.Country.Type
    object CustomHTTPHeaderName extends Subtype[String]
    type CustomHTTPHeaderName =
      zio.aws.wafv2.model.primitives.CustomHTTPHeaderName.Type
    object CustomHTTPHeaderValue extends Subtype[String]
    type CustomHTTPHeaderValue =
      zio.aws.wafv2.model.primitives.CustomHTTPHeaderValue.Type
    object DownloadUrl extends Subtype[String]
    type DownloadUrl = zio.aws.wafv2.model.primitives.DownloadUrl.Type
    object EntityDescription extends Subtype[String]
    type EntityDescription =
      zio.aws.wafv2.model.primitives.EntityDescription.Type
    object EntityId extends Subtype[String]
    type EntityId = zio.aws.wafv2.model.primitives.EntityId.Type
    object EntityName extends Subtype[String]
    type EntityName = zio.aws.wafv2.model.primitives.EntityName.Type
    object FieldIdentifier extends Subtype[String]
    type FieldIdentifier = zio.aws.wafv2.model.primitives.FieldIdentifier.Type
    object FieldToMatchData extends Subtype[String]
    type FieldToMatchData = zio.aws.wafv2.model.primitives.FieldToMatchData.Type
    object ForwardedIPHeaderName extends Subtype[String]
    type ForwardedIPHeaderName =
      zio.aws.wafv2.model.primitives.ForwardedIPHeaderName.Type
    object HTTPMethod extends Subtype[String]
    type HTTPMethod = zio.aws.wafv2.model.primitives.HTTPMethod.Type
    object HTTPVersion extends Subtype[String]
    type HTTPVersion = zio.aws.wafv2.model.primitives.HTTPVersion.Type
    object HeaderName extends Subtype[String]
    type HeaderName = zio.aws.wafv2.model.primitives.HeaderName.Type
    object HeaderValue extends Subtype[String]
    type HeaderValue = zio.aws.wafv2.model.primitives.HeaderValue.Type
    object IPAddress extends Subtype[String]
    type IPAddress = zio.aws.wafv2.model.primitives.IPAddress.Type
    object IPString extends Subtype[String]
    type IPString = zio.aws.wafv2.model.primitives.IPString.Type
    object JsonPointerPath extends Subtype[String]
    type JsonPointerPath = zio.aws.wafv2.model.primitives.JsonPointerPath.Type
    object LabelMatchKey extends Subtype[String]
    type LabelMatchKey = zio.aws.wafv2.model.primitives.LabelMatchKey.Type
    object LabelName extends Subtype[String]
    type LabelName = zio.aws.wafv2.model.primitives.LabelName.Type
    object ListMaxItems extends Subtype[Long]
    type ListMaxItems = zio.aws.wafv2.model.primitives.ListMaxItems.Type
    object LockToken extends Subtype[String]
    type LockToken = zio.aws.wafv2.model.primitives.LockToken.Type
    object LoginPathString extends Subtype[String]
    type LoginPathString = zio.aws.wafv2.model.primitives.LoginPathString.Type
    object MetricName extends Subtype[String]
    type MetricName = zio.aws.wafv2.model.primitives.MetricName.Type
    object NextMarker extends Subtype[String]
    type NextMarker = zio.aws.wafv2.model.primitives.NextMarker.Type
    object OutputUrl extends Subtype[String]
    type OutputUrl = zio.aws.wafv2.model.primitives.OutputUrl.Type
    object PaginationLimit extends Subtype[Int]
    type PaginationLimit = zio.aws.wafv2.model.primitives.PaginationLimit.Type
    object PolicyString extends Subtype[String]
    type PolicyString = zio.aws.wafv2.model.primitives.PolicyString.Type
    object PopulationSize extends Subtype[Long]
    type PopulationSize = zio.aws.wafv2.model.primitives.PopulationSize.Type
    object RateLimit extends Subtype[Long]
    type RateLimit = zio.aws.wafv2.model.primitives.RateLimit.Type
    object RegexPatternString extends Subtype[String]
    type RegexPatternString =
      zio.aws.wafv2.model.primitives.RegexPatternString.Type
    object ReleaseNotes extends Subtype[String]
    type ReleaseNotes = zio.aws.wafv2.model.primitives.ReleaseNotes.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.wafv2.model.primitives.ResourceArn.Type
    object ResponseCode extends Subtype[Int]
    type ResponseCode = zio.aws.wafv2.model.primitives.ResponseCode.Type
    object ResponseContent extends Subtype[String]
    type ResponseContent = zio.aws.wafv2.model.primitives.ResponseContent.Type
    object ResponseStatusCode extends Subtype[Int]
    type ResponseStatusCode =
      zio.aws.wafv2.model.primitives.ResponseStatusCode.Type
    object RulePriority extends Subtype[Int]
    type RulePriority = zio.aws.wafv2.model.primitives.RulePriority.Type
    object SampleWeight extends Subtype[Long]
    type SampleWeight = zio.aws.wafv2.model.primitives.SampleWeight.Type
    object SearchString extends Subtype[Chunk[Byte]]
    type SearchString = zio.aws.wafv2.model.primitives.SearchString.Type
    object SingleCookieName extends Subtype[String]
    type SingleCookieName = zio.aws.wafv2.model.primitives.SingleCookieName.Type
    object Size extends Subtype[Long]
    type Size = zio.aws.wafv2.model.primitives.Size.Type
    object SolveTimestamp extends Subtype[Long]
    type SolveTimestamp = zio.aws.wafv2.model.primitives.SolveTimestamp.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.wafv2.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.wafv2.model.primitives.TagValue.Type
    object TextTransformationPriority extends Subtype[Int]
    type TextTransformationPriority =
      zio.aws.wafv2.model.primitives.TextTransformationPriority.Type
    object TimeWindowDay extends Subtype[Int]
    type TimeWindowDay = zio.aws.wafv2.model.primitives.TimeWindowDay.Type
    object TimeWindowSecond extends Subtype[Long]
    type TimeWindowSecond = zio.aws.wafv2.model.primitives.TimeWindowSecond.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.wafv2.model.primitives.Timestamp.Type
    object TokenDomain extends Subtype[String]
    type TokenDomain = zio.aws.wafv2.model.primitives.TokenDomain.Type
    object URIString extends Subtype[String]
    type URIString = zio.aws.wafv2.model.primitives.URIString.Type
    object VendorName extends Subtype[String]
    type VendorName = zio.aws.wafv2.model.primitives.VendorName.Type
    object VersionKeyString extends Subtype[String]
    type VersionKeyString = zio.aws.wafv2.model.primitives.VersionKeyString.Type
  }
  type Conditions = List[zio.aws.wafv2.model.Condition]
  type CookieNames = List[SingleCookieName]
  type CountryCodes = List[zio.aws.wafv2.model.CountryCode]
  type CustomHTTPHeaders = List[zio.aws.wafv2.model.CustomHTTPHeader]
  type CustomResponseBodies =
    Map[EntityName, zio.aws.wafv2.model.CustomResponseBody]
  type ExcludedRules = List[zio.aws.wafv2.model.ExcludedRule]
  type Filters = List[zio.aws.wafv2.model.Filter]
  type FirewallManagerRuleGroups =
    List[zio.aws.wafv2.model.FirewallManagerRuleGroup]
  type HTTPHeaders = List[zio.aws.wafv2.model.HTTPHeader]
  type HeaderNames = List[FieldToMatchData]
  type IPAddresses = List[IPAddress]
  type IPSetSummaries = List[zio.aws.wafv2.model.IPSetSummary]
  type JsonPointerPaths = List[JsonPointerPath]
  type LabelSummaries = List[zio.aws.wafv2.model.LabelSummary]
  type Labels = List[zio.aws.wafv2.model.Label]
  type LogDestinationConfigs = List[ResourceArn]
  type LoggingConfigurations = List[zio.aws.wafv2.model.LoggingConfiguration]
  type ManagedRuleGroupConfigs =
    List[zio.aws.wafv2.model.ManagedRuleGroupConfig]
  type ManagedRuleGroupSummaries =
    List[zio.aws.wafv2.model.ManagedRuleGroupSummary]
  type ManagedRuleGroupVersions =
    List[zio.aws.wafv2.model.ManagedRuleGroupVersion]
  type ManagedRuleSetSummaries = List[zio.aws.wafv2.model.ManagedRuleSetSummary]
  type PublishedVersions =
    Map[VersionKeyString, zio.aws.wafv2.model.ManagedRuleSetVersion]
  type RedactedFields = List[zio.aws.wafv2.model.FieldToMatch]
  type RegexPatternSetSummaries =
    List[zio.aws.wafv2.model.RegexPatternSetSummary]
  type RegularExpressionList = List[zio.aws.wafv2.model.Regex]
  type ReleaseSummaries = List[zio.aws.wafv2.model.ReleaseSummary]
  type ResourceArns = List[ResourceArn]
  type RuleActionOverrides = List[zio.aws.wafv2.model.RuleActionOverride]
  type RuleGroupSummaries = List[zio.aws.wafv2.model.RuleGroupSummary]
  type RuleSummaries = List[zio.aws.wafv2.model.RuleSummary]
  type Rules = List[zio.aws.wafv2.model.Rule]
  type SampledHTTPRequests = List[zio.aws.wafv2.model.SampledHTTPRequest]
  type Statements = List[zio.aws.wafv2.model.Statement]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.wafv2.model.Tag]
  type TextTransformations = List[zio.aws.wafv2.model.TextTransformation]
  type TokenDomains = List[TokenDomain]
  type VersionsToPublish =
    Map[VersionKeyString, zio.aws.wafv2.model.VersionToPublish]
  type WebACLSummaries = List[zio.aws.wafv2.model.WebACLSummary]
}
