package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.LabelName
import scala.jdk.CollectionConverters._
final case class Label(name: LabelName) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.Label = {
    import Label.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.Label
      .builder()
      .name(LabelName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.Label.ReadOnly =
    zio.aws.wafv2.model.Label.wrap(buildAwsValue())
}
object Label {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.Label] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.Label = zio.aws.wafv2.model.Label(name)
    def name: LabelName
    def getName: ZIO[Any, Nothing, LabelName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.Label
  ) extends zio.aws.wafv2.model.Label.ReadOnly {
    override val name: LabelName =
      zio.aws.wafv2.model.primitives.LabelName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.Label
  ): zio.aws.wafv2.model.Label.ReadOnly = new Wrapper(impl)
}
