package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.{ListMaxItems, MetricName, ResourceArn}
import scala.jdk.CollectionConverters._
final case class GetSampledRequestsRequest(
    webAclArn: ResourceArn,
    ruleMetricName: MetricName,
    scope: zio.aws.wafv2.model.Scope,
    timeWindow: zio.aws.wafv2.model.TimeWindow,
    maxItems: ListMaxItems
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetSampledRequestsRequest = {
    import GetSampledRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetSampledRequestsRequest
      .builder()
      .webAclArn(ResourceArn.unwrap(webAclArn): java.lang.String)
      .ruleMetricName(MetricName.unwrap(ruleMetricName): java.lang.String)
      .scope(scope.unwrap)
      .timeWindow(timeWindow.buildAwsValue())
      .maxItems(ListMaxItems.unwrap(maxItems): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetSampledRequestsRequest.ReadOnly =
    zio.aws.wafv2.model.GetSampledRequestsRequest.wrap(buildAwsValue())
}
object GetSampledRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetSampledRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetSampledRequestsRequest =
      zio.aws.wafv2.model.GetSampledRequestsRequest(
        webAclArn,
        ruleMetricName,
        scope,
        timeWindow.asEditable,
        maxItems
      )
    def webAclArn: ResourceArn
    def ruleMetricName: MetricName
    def scope: zio.aws.wafv2.model.Scope
    def timeWindow: zio.aws.wafv2.model.TimeWindow.ReadOnly
    def maxItems: ListMaxItems
    def getWebAclArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(webAclArn)
    def getRuleMetricName: ZIO[Any, Nothing, MetricName] =
      ZIO.succeed(ruleMetricName)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getTimeWindow
        : ZIO[Any, Nothing, zio.aws.wafv2.model.TimeWindow.ReadOnly] =
      ZIO.succeed(timeWindow)
    def getMaxItems: ZIO[Any, Nothing, ListMaxItems] = ZIO.succeed(maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetSampledRequestsRequest
  ) extends zio.aws.wafv2.model.GetSampledRequestsRequest.ReadOnly {
    override val webAclArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.webAclArn())
    override val ruleMetricName: MetricName =
      zio.aws.wafv2.model.primitives.MetricName(impl.ruleMetricName())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val timeWindow: zio.aws.wafv2.model.TimeWindow.ReadOnly =
      zio.aws.wafv2.model.TimeWindow.wrap(impl.timeWindow())
    override val maxItems: ListMaxItems =
      zio.aws.wafv2.model.primitives.ListMaxItems(impl.maxItems())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetSampledRequestsRequest
  ): zio.aws.wafv2.model.GetSampledRequestsRequest.ReadOnly = new Wrapper(impl)
}
