package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.MetricName
import scala.jdk.CollectionConverters._
final case class VisibilityConfig(
    sampledRequestsEnabled: Boolean,
    cloudWatchMetricsEnabled: Boolean,
    metricName: MetricName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.VisibilityConfig = {
    import VisibilityConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.VisibilityConfig
      .builder()
      .sampledRequestsEnabled(sampledRequestsEnabled: java.lang.Boolean)
      .cloudWatchMetricsEnabled(cloudWatchMetricsEnabled: java.lang.Boolean)
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.VisibilityConfig.ReadOnly =
    zio.aws.wafv2.model.VisibilityConfig.wrap(buildAwsValue())
}
object VisibilityConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.VisibilityConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.VisibilityConfig =
      zio.aws.wafv2.model.VisibilityConfig(
        sampledRequestsEnabled,
        cloudWatchMetricsEnabled,
        metricName
      )
    def sampledRequestsEnabled: Boolean
    def cloudWatchMetricsEnabled: Boolean
    def metricName: MetricName
    def getSampledRequestsEnabled: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(sampledRequestsEnabled)
    def getCloudWatchMetricsEnabled: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(cloudWatchMetricsEnabled)
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.VisibilityConfig
  ) extends zio.aws.wafv2.model.VisibilityConfig.ReadOnly {
    override val sampledRequestsEnabled: Boolean =
      impl.sampledRequestsEnabled(): Boolean
    override val cloudWatchMetricsEnabled: Boolean =
      impl.cloudWatchMetricsEnabled(): Boolean
    override val metricName: MetricName =
      zio.aws.wafv2.model.primitives.MetricName(impl.metricName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.VisibilityConfig
  ): zio.aws.wafv2.model.VisibilityConfig.ReadOnly = new Wrapper(impl)
}
